% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsqca_ots_dts.R
\name{dtSweep}
\alias{dtSweep}
\title{DTS–QCA: Two-dimensional X–Y threshold sweep}
\usage{
dtSweep(
  dat,
  outcome = NULL,
  conditions = NULL,
  sweep_list_X,
  sweep_range_Y,
  pre_calibrated = NULL,
  dir.exp = NULL,
  include = "",
  incl.cut = 0.8,
  n.cut = 1,
  pri.cut = 0,
  extract_mode = c("first", "all", "essential"),
  return_details = TRUE,
  Yvar = NULL,
  Xvars = NULL
)
}
\arguments{
\item{dat}{Data frame containing the outcome and condition variables.}

\item{outcome}{Character. Outcome variable name. Supports negation with
tilde prefix (e.g., \code{"~Y"}) following QCA package conventions.}

\item{conditions}{Character vector. Names of condition variables.}

\item{sweep_list_X}{Named list. Each element is a numeric vector of
candidate thresholds for the corresponding X.}

\item{sweep_range_Y}{Numeric vector. Candidate thresholds for Y.}

\item{pre_calibrated}{Character vector or \code{NULL}. Names of condition
variables that have been pre-calibrated (e.g., via \code{QCA::calibrate()})
and should be passed through to \code{QCA::truthTable()} without
binarization. These variables must contain values in the \code{[0, 1]}
range. Variables not listed here will be binarized using \code{sweep_list_X}
thresholds as usual. Default is \code{NULL} (all variables binarized).
It is recommended to sweep variables on their original (raw) scale rather
than as pre-calibrated fuzzy values, because raw-scale thresholds are
easier to interpret substantively.}

\item{dir.exp}{Directional expectations for \code{minimize}.
If \code{NULL} (default), no directional expectations are applied.
To compute the \strong{intermediate solution}, specify a numeric vector
(1, 0, or -1 for each condition). Example: \code{dir.exp = c(1, 1, 1)}
for three conditions all expected to contribute positively.}

\item{include}{Inclusion rule for \code{minimize}. 
\code{""} (default, QCA compatible) computes the \strong{complex solution}
without logical remainders.
Use \code{"?"} to include logical remainders for \strong{parsimonious}
(with \code{dir.exp = NULL}) or \strong{intermediate} solutions
(with \code{dir.exp} specified).}

\item{incl.cut}{Consistency cutoff for \code{truthTable}.}

\item{n.cut}{Frequency cutoff for \code{truthTable}.}

\item{pri.cut}{PRI cutoff for \code{minimize}.}

\item{extract_mode}{Character. How to handle multiple solutions:
\code{"first"} (default), \code{"all"}, or \code{"essential"}.
See \code{\link{qca_extract}} for details.}

\item{return_details}{Logical. If \code{TRUE} (default), returns both
summary and detailed objects for use with \code{generate_report()}.}

\item{Yvar}{Deprecated. Use \code{outcome} instead.}

\item{Xvars}{Deprecated. Use \code{conditions} instead.}
}
\value{
If \code{return_details = FALSE}, a data frame with columns:
\itemize{
  \item \code{combo_id} — index of threshold combination
  \item \code{thrY} — threshold for Y
  \item \code{thrX} — character summary of X thresholds
  \item \code{expression} — minimized solution expression
  \item \code{inclS} — solution consistency
  \item \code{covS} — solution coverage
  \item (additional columns depending on \code{extract_mode})
}

If \code{return_details = TRUE}, a list with:
\itemize{
  \item \code{summary} — the data frame above
  \item \code{details} — list of runs with
    \code{combo_id}, \code{thrY}, \code{thrX_vec},
    \code{truth_table}, \code{solution}
}
}
\description{
Sweeps thresholds for multiple X variables and the outcome Y jointly.
For each combination of X thresholds and each candidate Y threshold, the
data are binarized and a crisp-set QCA is executed.
}
\examples{
# Load sample data
data(sample_data)

# === Three Types of QCA Solutions ===

# Quick demonstration with 2 conditions
sweep_list_X <- list(X1 = 7, X2 = 7)
sweep_range_Y <- 7

# 1. Complex Solution (default, QCA compatible)
result_comp <- dtSweep(
  dat = sample_data,
  outcome = "Y",
  conditions = c("X1", "X2"),
  sweep_list_X = sweep_list_X,
  sweep_range_Y = sweep_range_Y
  # include = "" (default), dir.exp = NULL (default)
)
head(result_comp$summary)

# 2. Parsimonious Solution (include = "?")
result_pars <- dtSweep(
  dat = sample_data,
  outcome = "Y",
  conditions = c("X1", "X2"),
  sweep_list_X = sweep_list_X,
  sweep_range_Y = sweep_range_Y,
  include = "?"  # Include logical remainders
)
head(result_pars$summary)

# 3. Intermediate Solution (include = "?" + dir.exp)
result_int <- dtSweep(
  dat = sample_data,
  outcome = "Y",
  conditions = c("X1", "X2"),
  sweep_list_X = sweep_list_X,
  sweep_range_Y = sweep_range_Y,
  include = "?",
  dir.exp = c(1, 1)  # Positive expectations
)
head(result_int$summary)

# === Threshold Sweep Example ===

# Using 2 conditions and 2 threshold levels
sweep_list_X <- list(
  X1 = 6:7,
  X2 = 6:7
)
sweep_range_Y <- 6:7

# Run dual threshold sweep (complex solutions by default)
result_quick <- dtSweep(
  dat = sample_data,
  outcome = "Y",
  conditions = c("X1", "X2"),
  sweep_list_X = sweep_list_X,
  sweep_range_Y = sweep_range_Y
)
head(result_quick$summary)

\donttest{
# Full analysis with 3 conditions (81 combinations)
sweep_list_X_full <- list(
  X1 = 6:8,
  X2 = 6:8,
  X3 = 6:8
)
sweep_range_Y_full <- 6:8

result_full <- dtSweep(
  dat = sample_data,
  outcome = "Y",
  conditions = c("X1", "X2", "X3"),
  sweep_list_X = sweep_list_X_full,
  sweep_range_Y = sweep_range_Y_full
)
head(result_full$summary)
}
}
