% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPC1_TFM.R
\name{PPC1_TFM}
\alias{PPC1_TFM}
\title{Projected Principal Component Analysis}
\usage{
PPC1_TFM(x, m, A, D, p)
}
\arguments{
\item{x}{A matrix of input data.}

\item{m}{The number of principal components to extract (integer).}

\item{A}{The true factor loadings matrix (matrix).}

\item{D}{The true uniquenesses matrix (matrix).}

\item{p}{The number of variables (integer).}
}
\value{
A list containing:
\item{Ap}{Estimated factor loadings.}
\item{Dp}{Estimated uniquenesses.}
\item{MSESigmaA}{Mean squared error for factor loadings.}
\item{MSESigmaD}{Mean squared error for uniquenesses.}
\item{LSigmaA}{Loss metric for factor loadings.}
\item{LSigmaD}{Loss metric for uniquenesses.}
}
\description{
This function computes Projected Principal Component Analysis (PPC) for the provided input data, estimating factor loadings and uniquenesses. It calculates mean squared errors and loss metrics for the estimated values compared to true values.
}
\examples{
\dontrun{
library(MASS)
library(relliptical)
library(SOPC)
PPC_MSESigmaA <- c()
PPC_MSESigmaD <- c()
PPC_LSigmaA <- c()
PPC_LSigmaD <- c()
result <- PPC1_TFM(data, m, A, D, p)
print(result)}
}
