% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradient_from_data.R
\name{gradient_from_data}
\alias{gradient_from_data}
\title{gradient or taphonomic conditions from data}
\usage{
gradient_from_data(x)
}
\arguments{
\item{x}{list or data frame}
}
\value{
a function for usage as gradient or taphonomic conditions, which can be passed to \code{apply_taphonomy} or \code{apply_niche}
}
\description{
Constructs a gradient or taphonomic conditions from a dataframe or list. If \code{x} is a dataframe, the first two columns are used, if \code{x} is a list the first two elements are used. The first entry is used as time/stratigraphic position, and the second as gradient/recovery probability.
}
\examples{
# water depth 2 km offshore as gradient
t = scenarioA$t_myr
l = list(t, scenarioA$wd_m[,"2km"])
f = gradient_from_data(l)
plot(t, f(t), type = "l")
}
