% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diag.R
\name{diag_test}
\alias{diag_test}
\title{Diagnostic Test Accuracy Assessment}
\usage{
diag_test(
  data,
  test,
  ref,
  positive = NULL,
  test_positive = NULL,
  conf.level = 0.95
)
}
\arguments{
\item{data}{A data.frame containing the test and reference variables.}

\item{test}{Unquoted name of the diagnostic test variable (binary).}

\item{ref}{Unquoted name of the reference standard variable (binary).}

\item{positive}{Character or numeric. Level representing "Positive" in REFERENCE.}

\item{test_positive}{Character or numeric. Level representing "Positive" in TEST.}

\item{conf.level}{Numeric. Confidence level (0-1). Default: 0.95.}
}
\value{
An object of class \code{diag_test} containing:
\itemize{
\item \code{table}: 2x2 confusion matrix
\item \code{stats}: Data frame with metrics and CIs
\item \code{labels}: List with labels used
\item \code{sample_size}: Total valid observations
}
}
\description{
Computes a comprehensive confusion matrix and diagnostic performance metrics
for binary classification tests.
}
\details{
\strong{Confusion Matrix Structure}
The function creates a 2x2 confusion matrix:
\itemize{
\item TP: True Positives
\item TN: True Negatives
\item FP: False Positives
\item FN: False Negatives
}

\strong{Metrics Calculated}
\itemize{
\item Sensitivity, Specificity, PPV, NPV
\item Accuracy, Prevalence
\item Likelihood Ratios, Youden's Index, F1 Score
}
}
