% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{format_dilutions}
\alias{format_dilutions}
\title{Format dilutions}
\usage{
format_dilutions(dilutions, dilution_values, sample_types)
}
\arguments{
\item{dilutions}{A vector of dilution factors, taken from plate object.}

\item{dilution_values}{A vector of dilution values corresponding to the dilution factors, taken from plate object. Used only for sorting purposes.}

\item{sample_types}{A vector of sample types taken from plate object.}
}
\value{
A formatted string that lists the dilution factors and their counts. Returns \code{NULL} if \code{dilutions} is \code{NULL}.
}
\description{
The function counts the number of times each dilution factor appears and sorts them in descending order based on the corresponding dilution values.
The output is a string that lists the dilution factors and their counts in the format \verb{count x dilution_factor}.
If the dilutions vector looks like \code{c("1/2", "1/2", "1/2", "1/3", "1/3", "1/4")}, the output will be \code{"3x1/2, 2x1/3, 1x1/4"}.
}
\keyword{internal}
