% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_weights.R
\name{plot_weights}
\alias{plot_weights}
\title{Visualizing the raw loading/weights of the features}
\usage{
plot_weights(
  sim_object,
  factor_num = 1,
  data = "omic.one",
  type = "scatter",
  show.legend = TRUE
)
}
\arguments{
\item{sim_object}{R object containing data to be plotted.}

\item{factor_num}{Integer or "all". Specifies which factor(s) to visualize.}

\item{data}{Character. Section of the data to visualize: "omic.one", "omic.two", or "integrated".}

\item{type}{Character. Type of plot: "scatter" or "histogram".}

\item{show.legend}{Logical. Whether to show the legend in the plot. Default is TRUE.}
}
\value{
A ggplot object or a combined grid of plots.
}
\description{
Generates scatter or histogram plots of feature loadings (weights) from simulated multi-omics data.
Supports plotting for omic.one, omic.two, or integrated views.
}
\examples{
output_obj <- simulate_twoOmicsData(
  vector_features = c(4000, 3000),
  n_samples = 100,
  n_factors = 2,
  signal.samples = NULL,
  signal.features.one = NULL,
  signal.features.two = NULL,
  snr = 2.5,
  num.factor = 'multiple',
  advanced_dist = 'mixed'
  )

plot_weights(
   sim_object = output_obj,
   factor_num = 1,
   data = 'omic.one',
   type = 'scatter',
   show.legend = FALSE
   )

plot_weights(
  sim_object = output_obj,
  factor_num = 2,
  data = 'omic.two',
  type = 'histogram'
  )
}
