% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkLocusANHIG.R
\name{checkLocusANHIG}
\alias{checkLocusANHIG}
\title{Check locus validity}
\usage{
checkLocusANHIG(variant)
}
\arguments{
\item{variant}{An amino acid motif or allele with an HLA locus name followed by an asterisk. This function ONLY evaluates if the locus in the entered variant is a protein-coding gene.}
}
\value{
TRUE if locus in entered variant are in the IPD-IMGT/HLA Database. Otherwise, a vector with FALSE and an error message is returned.
}
\description{
Checks if the locus in the entered variant is a protein-coding gene annotated by the IPD-IMGT/HLA Database
}
\note{
For internal SSHAARP use only.
}
\examples{
#Example of valid locus in a motif
checkLocusANHIG("DRB1*26F~28E")
#[1] TRUE

#Example of an invalid locus in an allele
checkLocusANHIG("BOO*01:01")
#[1] "FALSE"                     "BOO is not a valid locus."
}
