% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlrTools.R
\name{getMlrResample}
\alias{getMlrResample}
\title{Generate a fixed holdout instance for resampling}
\usage{
getMlrResample(task, dataset, data.seed = 1, prop = NULL)
}
\arguments{
\item{task}{mlr task}

\item{dataset}{e.g., census data set}

\item{data.seed}{seed}

\item{prop}{proportion, e.g., 2/3 take 2/3 of the data for training and 1/3
for test}
}
\value{
list: an mlr resample generated
with \code{\link[mlr]{makeFixedHoldoutInstance}}
}
\description{
Determines test/train split and applies
\code{\link[mlr]{makeFixedHoldoutInstance}}
}
\examples{
\donttest{
## Example downloads OpenML data, might take some time:
dataset <- getDataCensus(
task.type="classif",
nobs = 1e3,
nfactors = "high",
nnumericals = "high",
cardinality = "high",
data.seed=1,
cachedir= "oml.cache",
target = "age")

taskdata <- getMlrTask(dataset,
task.type = "classif",
data.seed = 1)

rsmpl <- getMlrResample(task=taskdata,
dataset = dataset,
data.seed = 1,
prop = 2/3)
}
}
\seealso{
\code{\link{getMlrTask}}
}
