% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeCDFPlot.R
\name{makeCDFPlot}
\alias{makeCDFPlot}
\title{Plot the elicited cumulative probabilities}
\usage{
makeCDFPlot(
  lower,
  v,
  p,
  upper,
  fontsize = 12,
  fit = NULL,
  dist = NULL,
  showFittedCDF = FALSE,
  showQuantiles = FALSE,
  ql = 0.05,
  qu = 0.95,
  ex = 1,
  sf = 3,
  xaxisLower = lower,
  xaxisUpper = upper,
  xlab = "x",
  ylab = expression(P(X <= x))
)
}
\arguments{
\item{lower}{lower limit for the uncertain quantity}

\item{v}{vector of values, for each value x in Pr(X<=x) = p
in the set of elicited probabilities}

\item{p}{vector of probabilities, for each value p in Pr(X<=x) = p
in the set of elicited probabilities}

\item{upper}{upper limit for the uncertain quantity}

\item{fontsize}{font size to be used in the plot}

\item{fit}{object of class \code{elicitation}}

\item{dist}{the fitted distribution to be plotted. Options are
\code{"normal"}, \code{"t"}, \code{"skewnormal"}, \code{"gamma"}, \code{"lognormal"},
\code{"logt"},\code{"beta"}, \code{"mirrorgamma"},
\code{"mirrorlognormal"}, \code{"mirrorlogt"} \code{"hist"} (for a histogram fit)}

\item{showFittedCDF}{logical. Should a fitted distribution function
be displayed?}

\item{showQuantiles}{logical. Should quantiles from the fitted distribution function
be displayed?}

\item{ql}{a lower quantile to be displayed.}

\item{qu}{an upper quantile to be displayed.}

\item{ex}{if the object \code{fit} contains judgements from multiple experts,
which (single) expert's judgements to show.}

\item{sf}{number of significant figures to be displayed.}

\item{xaxisLower}{lower limit for the x-axis.}

\item{xaxisUpper}{upper limit for the x-axis.}

\item{xlab}{x-axis label.}

\item{ylab}{y-axis label.}
}
\description{
Plots the elicited cumulative probabilities and, optionally,
a fitted CDF. Elicited are shown as filled circles, and
limits are shown as clear circles.
}
\examples{

\dontrun{
vQuartiles <- c(30, 35, 45)
pQuartiles<- c(0.25, 0.5, 0.75)
myfit <- fitdist(vals = vQuartiles, probs = pQuartiles, lower = 0)
makeCDFPlot(lower = 0, v = vQuartiles, p = pQuartiles,
 upper = 100, fit = myfit, dist = "gamma",
 showFittedCDF = TRUE, showQuantiles = TRUE)


}

}
