graph.VAR <-
function(design,VAR,dataset="regular",CL,tr,data=read.table(file.choose(new=FALSE)),xlab=NULL,ylab=NULL,ylim=NULL,legend=NULL){

  x<-1:nrow(data)
  MT<-nrow(data)
  
  if(design=="CRD"|design=="ATD"|design=="RBD"|design=="AB"|design=="Custom"){
    
    if(VAR=="RL"|VAR=="RB"){
      if(dataset=="regular"){
        A<-data[,2][data[,1]=="A"]
        B<-data[,2][data[,1]=="B"]
      }
      if(dataset=="trimmed"){
        if((sum(data[,1]=="A"))<6|(sum(data[,1]=="A"))>16){
          A<-data[,2][data[,1]=="A"]
        }
        if(6<=(sum(data[,1]=="A"))&(sum(data[,1]=="A"))<=12){
          A<-sort(data[,2][data[,1]=="A"])[2:(length(data[,2][data[,1]=="A"])-1)]
        }
        if(12<(sum(data[,1]=="A"))&(sum(data[,1]=="A"))<=16){
          A<-sort(data[,2][data[,1]=="A"])[3:(length(data[,2][data[,1]=="A"])-2)]
        }
        if((sum(data[,1]=="B"))<6|(sum(data[,1]=="B"))>16){
          B<-data[,2][data[,1]=="B"]
        }
        if(6<=(sum(data[,1]=="B"))&(sum(data[,1]=="B"))<=12){
          B<-sort(data[,2][data[,1]=="B"])[2:(length(data[,2][data[,1]=="B"])-1)]
        }
        if(12<(sum(data[,1]=="B"))&(sum(data[,1]=="B"))<=16){
          B<-sort(data[,2][data[,1]=="B"])[3:(length(data[,2][data[,1]=="B"])-2)] 
        }
      }
      if(VAR=="RL"){
        if (is.null(xlab)){
          xlab="Measurement Times"
        }
        if (is.null(ylab)){
          ylab="Scores"
        }
        if(design=="RBD"|design=="CRD"|design=="ATD"|design=="Custom"){
          plot(x,data[,2],type="n",xlab=xlab,ylab=ylab,ylim=ylim)
          points(x[data[,1]=="A"],data[,2][data[,1]=="A"],pch=1)
          points(x[data[,1]=="B"],data[,2][data[,1]=="B"],pch=16)
          a<-data[,2][data[,1]=="A"]
          b<-data[,2][data[,1]=="B"]
          MTA<-x[data[,1]=="A"]
          MTB<-x[data[,1]=="B"]
          for(it in 1:(length(a)-1)){
            lines(c(MTA[it],MTA[it+1]),c(a[it],a[it+1]),lty=2)
          }
          for(it in 1:(length(b)-1)){
            lines(c(MTB[it],MTB[it+1]),c(b[it],b[it+1]),lty=1)
          }
          lines(c(1,MT),c(min(A),min(A)),lty=3)
          lines(c(1,MT),c(max(A),max(A)),lty=3)
          lines(c(1,MT),c(min(B),min(B)),lty=6)
          lines(c(1,MT),c(max(B),max(B)),lty=6)
          if(is.null(legend))
            legend(locator(1),lty=c(2,1,3,6),pch=c(1,16,46,46),legend=c("A","B","range lines A","range lines B"),cex=0.8)
          else
            legend(legend[1],y=legend[2],lty=c(2,1,3,6),pch=c(1,16,46,46),legend=c("A","B","range lines A","range lines B"),cex=0.8)
        }
        if(design=="AB"){
          plot(x,data[,2],xlab=xlab,ylab=ylab,ylim=ylim,pch=16)
          lines(x[data[,1]=="A"],data[,2][data[,1]=="A"])
          lines(x[data[,1]=="B"],data[,2][data[,1]=="B"])
          lines(c(sum(data[,1]=="A")+0.5,sum(data[,1]=="A")+0.5),c(min(data[,2])-5,max(data[,2])+5),lty=2)
          mtext("A",side=3,at=(sum(data[,1]=="A")+1)/2)
          mtext("B",side=3,at=(sum(data[,1]=="A")+(sum(data[,1]=="B")+1)/2))
          lines(c(1,(sum(data[,1]=="A"))),c(min(A),min(A)),lty=3)
          lines(c(1,(sum(data[,1]=="A"))),c(max(A),max(A)),lty=3)
          lines(c((sum(data[,1]=="A")+1),MT),c(min(B),min(B)),lty=3)
          lines(c((sum(data[,1]=="A")+1),MT),c(max(B),max(B)),lty=3)
        }
      }
      if(VAR=="RB"){
        if (is.null(xlab)){
          xlab="Range bars"
        }
        if (is.null(ylab)){
          ylab="Scores"
        }
        plot(x,data[,2],type="n",xlab=xlab,ylab=ylab,ylim=ylim,xaxt="n")
        mtext("A",side=1,at=MT/4)
        mtext("B",side=1,at=MT*3/4)
        lines(c(MT/4,MT/4),c(min(A),max(A)))
        lines(c(MT*3/4,MT*3/4),c(min(B),max(B)))
        if(dataset=="trimmed"){
          if(6<=(sum(data[,1]=="A"))&(sum(data[,1]=="A"))<=12){
            points(MT/4,sort(data[,2][data[,1]=="A"])[1],pch=16)
            points(MT/4,sort(data[,2][data[,1]=="A"])[length(data[,2][data[,1]=="A"])],pch=16)
          }
          if(12<(sum(data[,1]=="A"))&(sum(data[,1]=="A"))<=16){
            points(MT/4,sort(data[,2][data[,1]=="A"])[1],pch=16)
            points(MT/4,sort(data[,2][data[,1]=="A"])[2],pch=16)
            points(MT/4,sort(data[,2][data[,1]=="A"])[length(data[,2][data[,1]=="A"])-1],pch=16)
            points(MT/4,sort(data[,2][data[,1]=="A"])[length(data[,2][data[,1]=="A"])],pch=16)
          }
          if(6<=(sum(data[,1]=="B"))&(sum(data[,1]=="B"))<=12){
            points(MT*3/4,sort(data[,2][data[,1]=="B"])[1],pch=16)
            points(MT*3/4,sort(data[,2][data[,1]=="B"])[length(data[,2][data[,1]=="B"])],pch=16)
          }
          if(12<(sum(data[,1]=="B"))&(sum(data[,1]=="B"))<=16){
            points(MT*3/4,sort(data[,2][data[,1]=="B"])[1],pch=16)
            points(MT*3/4,sort(data[,2][data[,1]=="B"])[2],pch=16)
            points(MT*3/4,sort(data[,2][data[,1]=="B"])[length(data[,2][data[,1]=="B"])-1],pch=16)
            points(MT*3/4,sort(data[,2][data[,1]=="B"])[length(data[,2][data[,1]=="B"])],pch=16)
          }
        }
        if(CL=="mean"){
          CLA<-mean(A)
          CLB<-mean(B)
        }
        if(CL=="median"){
          CLA<-median(A)
          CLB<-median(B)
        }
        if(CL=="bmed"){
          aa<-sort(A)
          bb<-sort(B)
          if(length(aa)<5){
            CLA<-median(A)
          }
          if(length(aa)==5|length(aa)==7|length(aa)==9|length(aa)==11){
            CLA<-(aa[ceiling(length(aa)/2)-1]+aa[ceiling(length(aa)/2)]+aa[ceiling(length(aa)/2)+1])/3
          }
          if(length(aa)>=13&length(aa)%%2==1){
            CLA<-(aa[ceiling(length(aa)/2)-2]+aa[ceiling(length(aa)/2)-1]+aa[ceiling(length(aa)/2)]+aa[ceiling(length(aa)/2)+1] +aa[ceiling(length(aa)/2)+2])/5
          }
          if(length(aa)==6|length(aa)==8|length(aa)==10|length(aa)==12){
            CLA<-1/6*aa[length(aa)/2-1]+1/3*aa[length(aa)/2]+1/3*aa[length(aa)/2+1]+1/6*aa[length(aa)/2+2]
          }
          if(length(aa)>13&length(aa)%%2==0){
            CLA<-1/10*aa[length(aa)/2-2]+1/5*aa[length(aa)/2-1]+1/5*aa[length(aa)/2]+1/5*aa[length(aa)/2+1]+1/5*aa[length(aa)/2+2]+1/10*aa[length(aa)/2+3]
          }
          if(length(bb)<5){
            CLB<-median(B)
          }
          if(length(bb)==5|length(bb)==7|length(bb)==9|length(bb)==11){
            CLB<-(bb[ceiling(length(bb)/2)-1]+bb[ceiling(length(bb)/2)]+bb[ceiling(length(bb)/2)+1])/3
          }
          if(length(bb)>=13&length(bb)%%2==1){
            CLB<-(bb[ceiling(length(bb)/2)-2]+bb[ceiling(length(bb)/2)-1]+bb[ceiling(length(bb)/2)]+bb[ceiling(length(bb)/2)+1]+bb[ceiling(length(bb)/2)+2])/5
          }
          if(length(bb)==6|length(bb)==8|length(bb)==10|length(bb)==12){
            CLB<-1/6*bb[length(bb)/2-1]+1/3*bb[length(bb)/2]+1/3*bb[length(bb)/2+1]+1/6*bb[length(bb)/2+2]
          }
          if(length(bb)>13&length(bb)%%2==0){
            CLB<-1/10*bb[length(bb)/2-2]+1/5*bb[length(bb)/2-1]+1/5*bb[length(bb)/2]+1/5*bb[length(bb)/2+1]+1/5*bb[length(bb)/2+2]+1/10*bb[length(bb)/2+3]
          }
        }  
        if(CL=="trimmean"){
          CLA<-mean(A,trim=tr)	
          CLB<-mean(B,trim=tr)
        }  
        if(CL=="mest"){
          hpsi<-function(x,bend=1.28){
            hpsi<-ifelse(abs(x)<=bend,x,bend*sign(x))
            hpsi
          }
          mest<-function(x,bend=1.28,na.rm=F){
            if(na.rm)x<-x[!is.na(x)]
            if(mad(x)==0)stop("MAD=0. The M-estimator cannot be computed.")
            y<-(x-median(x))/mad(x)
            A<-sum(hpsi(y,bend))
            B<-length(x[abs(y)<=bend])
            mest<-median(x)+mad(x)*A/B
            repeat{
              y<-(x-mest)/mad(x)
              A<-sum(hpsi(y,bend))
              B<-length(x[abs(y)<=bend])
              newmest<-mest+mad(x)*A/B
              if(abs(newmest-mest) <.0001)break
              mest<-newmest
            }
            mest
          }
          CLA<-mest(A,bend=tr)	
          CLB<-mest(B,bend=tr)
        } 
        lines(c(MT/4-MT/40,MT/4+MT/40),c(CLA,CLA))
        lines(c(MT*3/4-MT/40,MT*3/4+MT/40),c(CLB,CLB))
      }
         
    }
    if(VAR=="TR"){
      if (is.null(xlab)){
        xlab="Measurement Times"
      }
      if (is.null(ylab)){
        ylab="Scores"
      }
      A<-data[,2][data[,1]=="A"]
      B<-data[,2][data[,1]=="B"]
      a1<-A[1:ceiling(length(A)/2)]
      a2<-A[(ceiling(length(A)/2)+1):length(A)]
      b1<-B[1:ceiling(length(B)/2)]
      b2<-B[(ceiling(length(B)/2)+1):length(B)]
      if(dataset=="regular"){
        mina1<-min(a1)
        mina2<-min(a2)
        minb1<-min(b1)
        minb2<-min(b2)
        maxa1<-max(a1)
        maxa2<-max(a2)
        maxb1<-max(b1)
        maxb2<-max(b2)
      }
      if(dataset=="trimmed"){
        if(length(a1)<6|length(a1)>16){
          aa1<-a1
        }
        if(6<=length(a1)&length(a1)<=12){
          aa1<-sort(a1)[2:(length(a1)-1)]
        }
        if(12<length(a1)&length(a1)<=16){
          aa1<-sort(a1)[3:(length(a1)-2)]
        }
        if(length(a2)<6|length(a2)>16){
          aa2<-a2
        }
        if(6<=length(a2)&length(a2)<=12){
          aa2<-sort(a2)[2:(length(a2)-1)]
        }
        if(12<length(a2)&length(a2)<=16){
          aa2<-sort(a2)[3:(length(a2)-2)]
        }
        if(length(b1)<6|length(b1)>16){
          bb1<-b1
        }
        if(6<=length(b1)&length(b1)<=12){
          bb1<-sort(b1)[2:(length(b1)-1)]
        }
        if(12<length(b1)&length(b1)<=16){
          bb1<-sort(b1)[3:(length(b1)-2)] 
        }
        if(length(b2)<6|length(b2)>16){
          bb2<-b2
        }
        if(6<=length(b2)&length(b2)<=12){
          bb2<-sort(b2)[2:(length(b2)-1)]
        }
        if(12<length(b2)&length(b2)<=16){
          bb2<-sort(b2)[3:(length(b2)-2)] 
        }
        mina1<-min(aa1)
        mina2<-min(aa2)
        minb1<-min(bb1)
        minb2<-min(bb2)
        maxa1<-max(aa1)
        maxa2<-max(aa2)
        maxb1<-max(bb1)
        maxb2<-max(bb2)
      }
      minimaA<-c(mina1,mina2)
      maximaA<-c(maxa1,maxa2)
      minimaB<-c(minb1,minb2)
      maximaB<-c(maxb1,maxb2)
      if(design=="AB"){
        plot(x,data[,2],xlab=xlab,ylab=ylab,ylim=ylim,pch=16)
        lines(c(sum(data[,1]=="A")+0.5,sum(data[,1]=="A")+0.5),c(min(data[,2])-5,max(data[,2])+5),lty=2)
        mtext("A",side=3,at=(sum(data[,1]=="A")+1)/2)
        mtext("B",side=3,at=(sum(data[,1]=="A")+(sum(data[,1]=="B")+1)/2))
        points(c((length(a1)+1)/2,(length(a1)+1)/2),c(mina1,maxa1),pch=3,cex=1.3)
        points(c(length(a1)+(length(a2)+1)/2,length(a1)+(length(a2)+1)/2),c(mina2,maxa2),pch=3,cex=1.3)
        points(c((length(b1)+1)/2+sum(data[,1]=="A"),(length(b1)+1)/2+sum(data[,1]=="A")),c(minb1,maxb1),pch=3,cex=1.3)
        points(c(length(b1)+(length(b2)+1)/2+sum(data[,1]=="A"),length(b1)+(length(b2)+1)/2+sum(data[,1]=="A")),c(minb2,maxb2),pch=3,cex=1.3)
        timeA<-c((length(a1)+1)/2,length(a1)+(length(a2)+1)/2)
        timeB<-c((length(b1)+1)/2,length(b1)+(length(b2)+1)/2)
      }
      if(design=="CRD"|design=="RBD"|design=="ATD"|design=="Custom"){
        plot(x,data[,2],type="n",xlab=xlab,ylab=ylab,ylim=ylim)
        points(x[data[,1]=="A"],data[,2][data[,1]=="A"],pch=1)
        points(x[data[,1]=="B"],data[,2][data[,1]=="B"],pch=16)
        points(c(1/4*MT,1/4*MT),c(mina1,maxa1),pch=3,cex=1.3)
        points(c(3/4*MT,3/4*MT),c(mina2,maxa2),pch=3,cex=1.3)
        points(c(1/4*MT,1/4*MT),c(minb1,maxb1),pch=3,cex=1.3)
        points(c(3/4*MT,3/4*MT),c(minb2,maxb2),pch=3,cex=1.3)
        timeA<-c(1/4*MT,3/4*MT)
        timeB<-c(1/4*MT,3/4*MT)
      }
      interceptMINA<-coefficients(lm(minimaA~timeA))[1]
      slopeMINA<-coefficients(lm(minimaA~timeA))[2]
      interceptMAXA<-coefficients(lm(maximaA~timeA))[1]
      slopeMAXA<-coefficients(lm(maximaA~timeA))[2]
      interceptMINB<-coefficients(lm(minimaB~timeB))[1]
      slopeMINB<-coefficients(lm(minimaB~timeB))[2]
      interceptMAXB<-coefficients(lm(maximaB~timeB))[1]
      slopeMAXB<-coefficients(lm(maximaB~timeB))[2]
      if(design=="AB"){
        lines(c(1,sum(data[,1]=="A")),c(interceptMINA+slopeMINA,interceptMINA+slopeMINA*(sum(data[,1]=="A"))),lty=3)
        lines(c(1,sum(data[,1]=="A")),c(interceptMAXA+slopeMAXA,interceptMAXA+slopeMAXA*(sum(data[,1]=="A"))),lty=3)
        lines(c(sum(data[,1]=="A")+1,MT),c(interceptMINB+slopeMINB,interceptMINB+slopeMINB*(sum(data[,1]=="B"))),lty=3)
        lines(c(sum(data[,1]=="A")+1,MT),c(interceptMAXB+slopeMAXB,interceptMAXB+slopeMAXB*(sum(data[,1]=="B"))),lty=3)
      }
      if(design=="CRD"|design=="RBD"|design=="ATD"|design=="Custom"){
        lines(c(1,MT),c(interceptMINA+slopeMINA,interceptMINA+slopeMINA*MT),lty=2)
        lines(c(1,MT),c(interceptMAXA+slopeMAXA,interceptMAXA+slopeMAXA*MT),lty=2)
        lines(c(1,MT),c(interceptMINB+slopeMINB,interceptMINB+slopeMINB*MT),lty=3)
        lines(c(1,MT),c(interceptMAXB+slopeMAXB,interceptMAXB+slopeMAXB*MT),lty=3)
        if(is.null(legend))
          legend(locator(1),lty=c(0,0,2,3),pch=c(1,16,46,46),legend=c("A","B","trended range lines A","trended range lines B"),cex=0.8)
        else
          legend(legend[1],y=legend[2],lty=c(0,0,2,3),pch=c(1,16,46,46),legend=c("A","B","trended range lines A","trended range lines B"),cex=0.8)
      }
    }
  }
  
  if(design=="ABA"|design=="ABAB"){
    if(VAR=="RL"|VAR=="RB"){
      if(dataset=="regular"){
        A1<-data[,2][data[,1]=="A1"]
        B1<-data[,2][data[,1]=="B1"]
        A2<-data[,2][data[,1]=="A2"]
        B2<-data[,2][data[,1]=="B2"]
      }
      if(dataset=="trimmed"){
        if((sum(data[,1]=="A1"))<6|(sum(data[,1]=="A1"))>16){	
          A1<-data[,2][data[,1]=="A1"]
        }
        if(6<=(sum(data[,1]=="A1"))&(sum(data[,1]=="A1"))<=12){
          A1<-sort(data[,2][data[,1]=="A1"])[2:(length(data[,2][data[,1]=="A1"])-1)]
        }
        if(12<(sum(data[,1]=="A1"))&(sum(data[,1]=="A1"))<=16){
          A1<-sort(data[,2][data[,1]=="A1"])[3:(length(data[,2][data[,1]=="A1"])-2)]
        }
        if((sum(data[,1]=="B1"))<6|(sum(data[,1]=="B1"))>16){
          B1<-data[,2][data[,1]=="B1"]
        }
        if(6<=(sum(data[,1]=="B1"))&(sum(data[,1]=="B1"))<=12){
          B1<-sort(data[,2][data[,1]=="B1"])[2:(length(data[,2][data[,1]=="B1"])-1)]
        }
        if(12<(sum(data[,1]=="B1"))&(sum(data[,1]=="B1"))<=16){
          B1<-sort(data[,2][data[,1]=="B1"])[3:(length(data[,2][data[,1]=="B1"])-2)] 
        }
        if((sum(data[,1]=="A2"))<6|(sum(data[,1]=="A2"))>16){	
          A2<-data[,2][data[,1]=="A2"]
        }
        if(6<=(sum(data[,1]=="A2"))&(sum(data[,1]=="A2"))<=12){
          A2<-sort(data[,2][data[,1]=="A2"])[2:(length(data[,2][data[,1]=="A2"])-1)]
        }
        if(12<(sum(data[,1]=="A2"))&(sum(data[,1]=="A2"))<=16){
          A2<-sort(data[,2][data[,1]=="A2"])[3:(length(data[,2][data[,1]=="A2"])-2)]
        }
        if((sum(data[,1]=="B2"))<6|(sum(data[,1]=="B1"))>16){
          B2<-data[,2][data[,1]=="B2"]
        }
        if(6<=(sum(data[,1]=="B2"))&(sum(data[,1]=="B2"))<=12){
          B2<-sort(data[,2][data[,1]=="B2"])[2:(length(data[,2][data[,1]=="B2"])-1)]
        }
        if(12<(sum(data[,1]=="B2"))&(sum(data[,1]=="B2"))<=16){
          B2<-sort(data[,2][data[,1]=="B2"])[3:(length(data[,2][data[,1]=="B2"])-2)] 
        }
      }
      if(VAR=="RL"){
        if (is.null(xlab)){
          xlab="Measurement Times"
        }
        if (is.null(ylab)){
          ylab="Scores"
        }
        plot(x,data[,2],xlab=xlab,ylab=ylab,ylim=ylim,pch=16)
        lines(x[data[,1]=="A1"],data[,2][data[,1]=="A1"])
        lines(x[data[,1]=="B1"],data[,2][data[,1]=="B1"])
        lines(x[data[,1]=="A2"],data[,2][data[,1]=="A2"])
        lines(c(sum(data[,1]=="A1")+0.5,sum(data[,1]=="A1")+0.5),c(min(data[,2])-5,max(data[,2])+5),lty=2)
        lines(c(sum(data[,1]=="A1")+sum(data[,1]=="B1")+0.5,sum(data[,1]=="A1")+sum(data[,1]=="B1")+0.5),c(min(data[,2])-5,max(data[,2])+5),lty=2)
        mtext("A",side=3,at=(sum(data[,1]=="A1")+1)/2)
        mtext("B",side=3,at=(sum(data[,1]=="A1")+(sum(data[,1]=="B1")+1)/2))
        mtext("A",side=3,at=(sum(data[,1]=="A1")+sum(data[,1]=="B1")+(sum(data[,1]=="A2")+1)/2))
        lines(c(1,(sum(data[,1]=="A1"))),c(min(A1),min(A1)),lty=3)
        lines(c(1,(sum(data[,1]=="A1"))),c(max(A1),max(A1)),lty=3)
        lines(c((sum(data[,1]=="A1")+1),(sum(data[,1]=="A1")+sum(data[,1]=="B1"))),c(min(B1),min(B1)),lty=3)
        lines(c((sum(data[,1]=="A1")+1),(sum(data[,1]=="A1")+sum(data[,1]=="B1"))),c(max(B1),max(B1)),lty=3)
        lines(c((sum(data[,1]=="A1")+sum(data[,1]=="B1")+1),(sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2"))),c(min(A2),min(A2)),lty=3)
        lines(c((sum(data[,1]=="A1")+sum(data[,1]=="B1")+1),(sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2"))),c(max(A2),max(A2)),lty=3)
        if(design=="ABAB"){
          lines(x[data[,1]=="B2"],data[,2][data[,1]=="B2"])
          mtext("B",side=3,at=(sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2")+(sum(data[,1]=="B2")+1)/2))
          lines(c(sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2")+0.5,sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2")+0.5),c(min(data[,2])-5,max(data[,2])+5),lty=2)
          lines(c((sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2")+1),nrow(data)),c(min(B2),min(B2)),lty=3)
          lines(c((sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2")+1),nrow(data)),c(max(B2),max(B2)),lty=3)
        }
      }
      if(VAR=="RB"){
        if (is.null(xlab)){
          xlab="Range bars"
        }
        if (is.null(ylab)){
          ylab="Scores"
        }
        if(CL=="mean"){
          CLA1<-mean(A1)
          CLB1<-mean(B1)
          CLA2<-mean(A2)
          CLB2<-mean(B2)
        }
        if(CL=="median"){
          CLA1<-median(A1)
          CLB1<-median(B1)
          CLA2<-median(A2)
          CLB2<-median(B2)
        }
        if(CL=="bmed"){
          aa1<-sort(A1)
          bb1<-sort(B1)
          aa2<-sort(A2)
          bb2<-sort(B2)
          if(length(aa1)<5){
            CLA1<-median(data[,2][data[,1]=="A1"])
          }
          if(length(aa1)==5|length(aa1)==7|length(aa1)==9|length(aa1)==11){
            CLA1<-(aa1[ceiling(length(aa1)/2)-1]+aa1[ceiling(length(aa1)/2)]+aa1[ceiling(length(aa1)/2)+1])/3
          }
          if(length(aa1)>=13&length(aa1)%%2==1){
            CLA1<-(aa1[ceiling(length(aa1)/2)-2]+aa1[ceiling(length(aa1)/2)-1]+aa1[ceiling(length(aa1)/2)]+aa1[ceiling(length(aa1)/2)+1] +aa1[ceiling(length(aa1)/2)+2])/5
          }
          if(length(aa1)==6|length(aa1)==8|length(aa1)==10|length(aa1)==12){
            CLA1<-1/6*aa1[length(aa1)/2-1]+1/3*aa1[length(aa1)/2]+1/3*aa1[length(aa1)/2+1]+1/6*aa1[length(aa1)/2+2]
          }
          if(length(aa1)>13&length(aa1)%%2==0){
            CLA1<-1/10*aa1[length(aa1)/2-2]+1/5*aa1[length(aa1)/2-1]+1/5*aa1[length(aa1)/2]+1/5*aa1[length(aa1)/2+1]+1/5*aa1[length(aa1)/2+2]+1/10*aa1[length(aa1)/2+3]
          }
          if(length(bb1)<5){
            CLB1<-median(data[,2][data[,1]=="B1"])
          }
          if(length(bb1)==5|length(bb1)==7|length(bb1)==9|length(bb1)==11){
            CLB1<-(bb1[ceiling(length(bb1)/2)-1]+bb1[ceiling(length(bb1)/2)]+bb1[ceiling(length(bb1)/2)+1])/3
          }
          if(length(bb1)>=13&length(bb1)%%2==1){
            CLB1<-(bb1[ceiling(length(bb1)/2)-2]+bb1[ceiling(length(bb1)/2)-1]+bb1[ceiling(length(bb1)/2)]+bb1[ceiling(length(bb1)/2)+1]+bb1[ceiling(length(bb1)/2)+2])/5
          }
          if(length(bb1)==6|length(bb1)==8|length(bb1)==10|length(bb1)==12){
            CLB1<-1/6*bb1[length(bb1)/2-1]+1/3*bb1[length(bb1)/2]+1/3*bb1[length(bb1)/2+1]+1/6*bb1[length(bb1)/2+2]
          }
          if(length(bb1)>13&length(bb1)%%2==0){
            CLB1<-1/10*bb1[length(bb1)/2-2]+1/5*bb1[length(bb1)/2-1]+1/5*bb1[length(bb1)/2]+1/5*bb1[length(bb1)/2+1]+1/5*bb1[length(bb1)/2+2]+1/10*bb1[length(bb1)/2+3]
          }
          if(length(aa2)<5){
            CLA2<-median(data[,2][data[,1]=="A2"])
          }
          if(length(aa2)==5|length(aa2)==7|length(aa2)==9|length(aa2)==11){
            CLA2<-(aa2[ceiling(length(aa2)/2)-1]+aa2[ceiling(length(aa2)/2)]+aa2[ceiling(length(aa2)/2)+1])/3
          }
          if(length(aa2)>=13&length(aa2)%%2==1){
            CLA2<-(aa2[ceiling(length(aa2)/2)-2]+aa2[ceiling(length(aa2)/2)-1]+aa2[ceiling(length(aa2)/2)]+aa2[ceiling(length(aa2)/2)+1] +aa2[ceiling(length(aa2)/2)+2])/5
          }
          if(length(aa2)==6|length(aa2)==8|length(aa2)==10|length(aa2)==12){
            CLA2<-1/6*aa2[length(aa2)/2-1]+1/3*aa2[length(aa2)/2]+1/3*aa2[length(aa2)/2+1]+1/6*aa2[length(aa2)/2+2]
          }
          if(length(aa2)>13&length(aa2)%%2==0){
            CLA2<-1/10*aa2[length(aa2)/2-2]+1/5*aa2[length(aa2)/2-1]+1/5*aa2[length(aa2)/2]+1/5*aa2[length(aa2)/2+1]+1/5*aa2[length(aa2)/2+2]+1/10*aa2[length(aa2)/2+3]
          }
          if(length(bb2)<5){
            CLB2<-median(data[,2][data[,1]=="B2"])
          }
          if(length(bb2)==5|length(bb2)==7|length(bb2)==9|length(bb2)==11){
            CLB2<-(bb2[ceiling(length(bb2)/2)-1]+bb2[ceiling(length(bb2)/2)]+bb2[ceiling(length(bb2)/2)+1])/3
          }
          if(length(bb2)>=13&length(bb2)%%2==1){
            CLB2<-(bb2[ceiling(length(bb2)/2)-2]+bb2[ceiling(length(bb2)/2)-1]+bb2[ceiling(length(bb2)/2)]+bb2[ceiling(length(bb2)/2)+1]+bb2[ceiling(length(bb2)/2)+2])/5
          }
          if(length(bb2)==6|length(bb2)==8|length(bb2)==10|length(bb2)==12){
            CLB2<-1/6*bb2[length(bb2)/2-1]+1/3*bb2[length(bb2)/2]+1/3*bb2[length(bb2)/2+1]+1/6*bb2[length(bb2)/2+2]
          }
          if(length(bb2)>13&length(bb2)%%2==0){
            CLB2<-1/10*bb2[length(bb2)/2-2]+1/5*bb2[length(bb2)/2-1]+1/5*bb2[length(bb2)/2]+1/5*bb2[length(bb2)/2+1]+1/5*bb2[length(bb2)/2+2]+1/10*bb2[length(bb2)/2+3]
          }
        }
        if(CL=="trimmean"){
          CLA1<-mean(A1,trim=tr)
          CLB1<-mean(B1,trim=tr)
          CLA2<-mean(A2,trim=tr)
          CLB2<-mean(B2,trim=tr)
        }
        if(CL=="mest"){
          hpsi<-function(x,bend=1.28){
            hpsi<-ifelse(abs(x)<=bend,x,bend*sign(x))
            hpsi
          }
          mest<-function(x,bend=1.28,na.rm=F){
            if(na.rm)x<-x[!is.na(x)]
            if(mad(x)==0)stop("MAD=0. The M-estimator cannot be computed.")
            y<-(x-median(x))/mad(x)
            A<-sum(hpsi(y,bend))
            B<-length(x[abs(y)<=bend])
            mest<-median(x)+mad(x)*A/B
            repeat{
              y<-(x-mest)/mad(x)
              A<-sum(hpsi(y,bend))
              B<-length(x[abs(y)<=bend])
              newmest<-mest+mad(x)*A/B
              if(abs(newmest-mest) <.0001)break
              mest<-newmest
            }
            mest
          }
          CLA1<-mest(A1,bend=tr)
          CLB1<-mest(B1,bend=tr)
          CLA2<-mest(A2,bend=tr)
          CLB2<-mest(B2,bend=tr)
        }
        plot(x,data[,2],type="n",xlab=xlab,ylab=ylab,ylim=ylim,xaxt="n")
        mtext("A",side=1,at=(sum(data[,1]=="A1")+1)/2)
        mtext("B",side=1,at=(sum(data[,1]=="A1")+(sum(data[,1]=="B1")+1)/2))
        mtext("A",side=1,at=(sum(data[,1]=="A1")+sum(data[,1]=="B1")+(sum(data[,1]=="A2")+1)/2))
        lines(c((sum(data[,1]=="A1")+1)/2,(sum(data[,1]=="A1")+1)/2),c(min(A1),max(A1)))
        lines(c((sum(data[,1]=="A1")+(sum(data[,1]=="B1")+1)/2),(sum(data[,1]=="A1")+(sum(data[,1]=="B1")+1)/2)),c(min(B1),max(B1)))
        lines(c((sum(data[,1]=="A1")+sum(data[,1]=="B1")+(sum(data[,1]=="A2")+1)/2),(sum(data[,1]=="A1")+sum(data[,1]=="B1")+(sum(data[,1]=="A2")+1)/2)),c(min(A2),max(A2)))
        lines(c(((sum(data[,1]=="A1")+1)/2)-MT/40,((sum(data[,1]=="A1")+1)/2)+MT/40),c(CLA1,CLA1))
        lines(c(((sum(data[,1]=="A1")+(sum(data[,1]=="B1")+1)/2))-MT/40,((sum(data[,1]=="A1")+(sum(data[,1]=="B1")+1)/2))+MT/40),c(CLB1,CLB1))
        lines(c(((sum(data[,1]=="A1")+sum(data[,1]=="B1")+(sum(data[,1]=="A2")+1)/2))-MT/40,((sum(data[,1]=="A1")+sum(data[,1]=="B1")+(sum(data[,1]=="A2")+1)/2))+MT/40),c(CLA2,CLA2))
        if(design=="ABAB"){
          mtext("B",side=1,at=(sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2")+(sum(data[,1]=="B2")+1)/2))
          lines(c((sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2")+(sum(data[,1]=="B2")+1)/2),(sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2")+(sum(data[,1]=="B2")+1)/2)),c(min(A2),max(A2)))
          lines(c(((sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2")+(sum(data[,1]=="B2")+1)/2))-MT/40,((sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2")+(sum(data[,1]=="B2")+1)/2))+MT/40),c(CLB2,CLB2))
        }
        if(dataset=="trimmed"){
          if(6<=sum(data[,1]=="A1")&sum(data[,1]=="A1")<=12){
            points((sum(data[,1]=="A1")+1)/2,sort(data[,2][data[,1]=="A1"])[1],pch=16)
            points((sum(data[,1]=="A1")+1)/2,sort(data[,2][data[,1]=="A1"])[length(data[,2][data[,1]=="A1"])],pch=16)
          }
          if(12<sum(data[,1]=="A1")&sum(data[,1]=="A1")<=16){
            points((sum(data[,1]=="A1")+1)/2,sort(data[,2][data[,1]=="A1"])[1],pch=16)
            points((sum(data[,1]=="A1")+1)/2,sort(data[,2][data[,1]=="A1"])[2],pch=16)
            points((sum(data[,1]=="A1")+1)/2,sort(data[,2][data[,1]=="A1"])[length(data[,2][data[,1]=="A1"])-1],pch=16)
            points((sum(data[,1]=="A1")+1)/2,sort(data[,2][data[,1]=="A1"])[length(data[,2][data[,1]=="A1"])],pch=16)
          }
          if(6<=sum(data[,1]=="B1")&sum(data[,1]=="B1")<=12){
            points((sum(data[,1]=="A1")+(sum(data[,1]=="B1")+1)/2),sort(data[,2][data[,1]=="B1"])[1],pch=16)
            points((sum(data[,1]=="A1")+(sum(data[,1]=="B1")+1)/2),sort(data[,2][data[,1]=="B1"])[length(data[,2][data[,1]=="B1"])],pch=16)
          }
          if(12<sum(data[,1]=="B1")&sum(data[,1]=="B1")<=16){
            points((sum(data[,1]=="A1")+(sum(data[,1]=="B1")+1)/2),sort(data[,2][data[,1]=="B1"])[1],pch=16)
            points((sum(data[,1]=="A1")+(sum(data[,1]=="B1")+1)/2),sort(data[,2][data[,1]=="B1"])[2],pch=16)
            points((sum(data[,1]=="A1")+(sum(data[,1]=="B1")+1)/2),sort(data[,2][data[,1]=="B1"])[length(data[,2][data[,1]=="B1"])-1],pch=16)
            points((sum(data[,1]=="A1")+(sum(data[,1]=="B1")+1)/2),sort(data[,2][data[,1]=="B1"])[length(data[,2][data[,1]=="B1"])],pch=16)
          }
          if(6<=sum(data[,1]=="A2")&sum(data[,1]=="A2")<=12){
            points((sum(data[,1]=="A1")+sum(data[,1]=="B1")+(sum(data[,1]=="A2")+1)/2),sort(data[,2][data[,1]=="A2"])[1],pch=16)
            points((sum(data[,1]=="A1")+sum(data[,1]=="B1")+(sum(data[,1]=="A2")+1)/2),sort(data[,2][data[,1]=="A2"])[length(data[,2][data[,1]=="A2"])],pch=16)
          }
          if(12<sum(data[,1]=="A2")&sum(data[,1]=="A2")<=16){
            points((sum(data[,1]=="A1")+sum(data[,1]=="B1")+(sum(data[,1]=="A2")+1)/2),sort(data[,2][data[,1]=="A2"])[1],pch=16)
            points((sum(data[,1]=="A1")+sum(data[,1]=="B1")+(sum(data[,1]=="A2")+1)/2),sort(data[,2][data[,1]=="A2"])[2],pch=16)
            points((sum(data[,1]=="A1")+sum(data[,1]=="B1")+(sum(data[,1]=="A2")+1)/2),sort(data[,2][data[,1]=="A2"])[length(data[,2][data[,1]=="A2"])-1],pch=16)
            points((sum(data[,1]=="A1")+sum(data[,1]=="B1")+(sum(data[,1]=="A2")+1)/2),sort(data[,2][data[,1]=="A2"])[length(data[,2][data[,1]=="A2"])],pch=16)
          }
          if(design=="ABAB"){
            if(6<=sum(data[,1]=="B2")&sum(data[,1]=="B2")<=12){
              points((sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2")+(sum(data[,1]=="B2")+1)/2),sort(data[,2][data[,1]=="B2"])[1],pch=16)
              points((sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2")+(sum(data[,1]=="B2")+1)/2),sort(data[,2][data[,1]=="B2"])[length(data[,2][data[,1]=="B2"])],pch=16)
            }
            if(12<sum(data[,1]=="B2")&sum(data[,1]=="B2")<=16){
              points((sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2")+(sum(data[,1]=="B2")+1)/2),sort(data[,2][data[,1]=="B2"])[1],pch=16)
              points((sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2")+(sum(data[,1]=="B2")+1)/2),sort(data[,2][data[,1]=="B2"])[2],pch=16)
              points((sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2")+(sum(data[,1]=="B2")+1)/2),sort(data[,2][data[,1]=="B2"])[length(data[,2][data[,1]=="B2"])-1],pch=16)
              points((sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2")+(sum(data[,1]=="B2")+1)/2),sort(data[,2][data[,1]=="B2"])[length(data[,2][data[,1]=="B2"])],pch=16)
            }
          }
        }
      }
    }
    if(VAR=="TR"){
      A1<-data[,2][data[,1]=="A1"]
      B1<-data[,2][data[,1]=="B1"]
      A2<-data[,2][data[,1]=="A2"]
      B2<-data[,2][data[,1]=="B2"]
      a11<-A1[1:ceiling(length(A1)/2)]
      a12<-A1[(ceiling(length(A1)/2)+1):length(A1)]
      b11<-B1[1:ceiling(length(B1)/2)]
      b12<-B1[(ceiling(length(B1)/2)+1):length(B1)]
      a21<-A2[1:ceiling(length(A2)/2)]
      a22<-A2[(ceiling(length(A2)/2)+1):length(A2)]
      b21<-B2[1:ceiling(length(B2)/2)]
      b22<-B2[(ceiling(length(B2)/2)+1):length(B2)]
      if(dataset=="regular"){
        mina11<-min(a11)
        maxa11<-max(a11)
        mina12<-min(a12)
        maxa12<-max(a12)
        minb11<-min(b11)
        maxb11<-max(b11)
        minb12<-min(b12)
        maxb12<-max(b12)
        mina21<-min(a21)
        maxa21<-max(a21)
        mina22<-min(a22)
        maxa22<-max(a22)
        minb21<-min(b21)
        maxb21<-max(b21)
        minb22<-min(b22)
        maxb22<-max(b22)
      }
      if(dataset=="trimmed"){
        if(length(a11)<6|length(a11)>16){	
          aa11<-a11
        }
        if(6<=length(a11)&length(a11)<=12){
          aa11<-sort(a11)[2:(length(a11)-1)]
        }
        if(12<length(a11)&length(a11)<=16){
          aa11<-sort(a11)[3:(length(a11)-2)]
        }
        if(length(a12)<6|length(a12)>16){	
          aa12<-a12
        }
        if(6<=length(a12)&length(a12)<=12){
          aa12<-sort(a12)[2:(length(a12)-1)]
        }
        if(12<length(a12)&length(a12)<=16){
          aa12<-sort(a12)[3:(length(a12)-2)]
        }
        if(length(b11)<6|length(b11)>16){
          bb11<-b11
        }
        if(6<=length(b11)&length(b11)<=12){
          bb11<-sort(b11)[2:(length(b11)-1)]
        }
        if(12<length(b11)&length(b11)<=16){
          bb11<-sort(b11)[3:(length(b11)-2)] 
        }
        if(length(b12)<6|length(b12)>16){
          bb12<-b12
        }
        if(6<=length(b12)&length(b12)<=12){
          bb12<-sort(b12)[2:(length(b12)-1)]
        }
        if(12<length(b12)&length(b12)<=16){
          bb12<-sort(b12)[3:(length(b12)-2)] 
        }
        if(length(a21)<6|length(a21)>16){	
          aa21<-a21
        }
        if(6<=length(a21)&length(a21)<=12){
          aa21<-sort(a21)[2:(length(a21)-1)]
        }
        if(12<length(a21)&length(a21)<=16){
          aa21<-sort(a21)[3:(length(a21)-2)]
        }
        if(length(a22)<6|length(a22)>16){	
          aa22<-a22
        }
        if(6<=length(a22)&length(a22)<=12){
          aa22<-sort(a22)[2:(length(a22)-1)]
        }
        if(12<length(a22)&length(a22)<=16){
          aa22<-sort(a22)[3:(length(a22)-2)]
        }
        if(length(b21)<6|length(b21)>16){
          bb21<-b21
        }
        if(6<=length(b21)&length(b21)<=12){
          bb21<-sort(b21)[2:(length(b21)-1)]
        }
        if(12<length(b21)&length(b21)<=16){
          bb21<-sort(b21)[3:(length(b21)-2)] 
        }
        if(length(b22)<6|length(b22)>16){
          bb22<-b22
        }
        if(6<=length(b22)&length(b22)<=12){
          bb22<-sort(b22)[2:(length(b22)-1)]
        }
        if(12<length(b22)&length(b22)<=16){
          bb22<-sort(b22)[3:(length(b22)-2)] 
        }
        mina11<-min(aa11)
        maxa11<-max(aa11)
        mina12<-min(aa12)
        maxa12<-max(aa12)
        minb11<-min(bb11)
        maxb11<-max(bb11)
        minb12<-min(bb12)
        maxb12<-max(bb12)
        mina21<-min(aa21)
        maxa21<-max(aa21)
        mina22<-min(aa22)
        maxa22<-max(aa22)
        minb21<-min(bb21)
        maxb21<-max(bb21)
        minb22<-min(bb22)
        maxb22<-max(bb22)
      }
      if (is.null(xlab)){
        xlab="Measurement Times"
      }
      if (is.null(ylab)){
        ylab="Scores"
      }
      minimaA1<-c(mina11,mina12)
      maximaA1<-c(maxa11,maxa12)
      minimaB1<-c(minb11,minb12)
      maximaB1<-c(maxb11,maxb12)
      minimaA2<-c(mina21,mina22)
      maximaA2<-c(maxa21,maxa22)
      minimaB2<-c(minb21,minb22)
      maximaB2<-c(maxb21,maxb22)
      plot(x,data[,2],xlab=xlab,ylab=ylab,ylim=ylim,pch=16)
      lines(c(sum(data[,1]=="A1")+0.5,sum(data[,1]=="A1")+0.5),c(min(data[,2])-5,max(data[,2])+5),lty=2)
      lines(c(sum(data[,1]=="A1")+sum(data[,1]=="B1")+0.5,sum(data[,1]=="A1")+sum(data[,1]=="B1")+0.5),c(min(data[,2])-5,max(data[,2])+5),lty=2)
      mtext("A",side=3,at=(sum(data[,1]=="A1")+1)/2)
      mtext("B",side=3,at=(sum(data[,1]=="A1")+(sum(data[,1]=="B1")+1)/2))
      mtext("A",side=3,at=(sum(data[,1]=="A1")+sum(data[,1]=="B1")+(sum(data[,1]=="A2")+1)/2))
      points(c((length(a11)+1)/2,(length(a11)+1)/2),c(mina11,maxa11),pch=3,cex=1.3)
      points(c(length(a11)+(length(a12)+1)/2,length(a11)+(length(a12)+1)/2),c(mina12,maxa12),pch=3,cex=1.3)
      points(c((length(b11)+1)/2+sum(data[,1]=="A1"),(length(b11)+1)/2+sum(data[,1]=="A1")),c(minb11,maxb11),pch=3,cex=1.3)
      points(c(length(b11)+(length(b12)+1)/2+sum(data[,1]=="A1"),length(b11)+(length(b12)+1)/2+sum(data[,1]=="A1")),c(minb12,maxb12),pch=3,cex=1.3)
      points(c((length(a21)+1)/2+sum(data[,1]=="A1")+sum(data[,1]=="B1"),(length(a21)+1)/2+sum(data[,1]=="A1")+sum(data[,1]=="B1")),c(mina21,maxa21),pch=3,cex=1.3)
      points(c(length(a21)+(length(a22)+1)/2+sum(data[,1]=="A1")+sum(data[,1]=="B1"),length(a21)+(length(a22)+1)/2+sum(data[,1]=="A1")+sum(data[,1]=="B1")),c(mina22,maxa22),pch=3,cex=1.3)
      timeA1<-c((length(a11)+1)/2,length(a11)+(length(a12)+1)/2)
      interceptMINA1<-coefficients(lm(minimaA1~timeA1))[1]
      slopeMINA1<-coefficients(lm(minimaA1~timeA1))[2]
      lines(c(1,sum(data[,1]=="A1")),c(interceptMINA1+slopeMINA1,interceptMINA1+slopeMINA1*(sum(data[,1]=="A1"))),lty=3)
      interceptMAXA1<-coefficients(lm(maximaA1~timeA1))[1]
      slopeMAXA1<-coefficients(lm(maximaA1~timeA1))[2]
      lines(c(1,sum(data[,1]=="A1")),c(interceptMAXA1+slopeMAXA1,interceptMAXA1+slopeMAXA1*(sum(data[,1]=="A1"))),lty=3)
      timeB1<-c((length(b11)+1)/2,length(b11)+(length(b12)+1)/2)
      interceptMINB1<-coefficients(lm(minimaB1~timeB1))[1]
      slopeMINB1<-coefficients(lm(minimaB1~timeB1))[2]
      lines(c(sum(data[,1]=="A1")+1,sum(data[,1]=="A1")+sum(data[,1]=="B1")),c(interceptMINB1+slopeMINB1,interceptMINB1+slopeMINB1*(sum(data[,1]=="B1"))),lty=3)
      interceptMAXB1<-coefficients(lm(maximaB1~timeB1))[1]
      slopeMAXB1<-coefficients(lm(maximaB1~timeB1))[2]
      lines(c(sum(data[,1]=="A1")+1,sum(data[,1]=="A1")+sum(data[,1]=="B1")),c(interceptMAXB1+slopeMAXB1,interceptMAXB1+slopeMAXB1*(sum(data[,1]=="B1"))),lty=3)
      timeA2<-c((length(a21)+1)/2,length(a21)+(length(a22)+1)/2)
      interceptMINA2<-coefficients(lm(minimaA2~timeA2))[1]
      slopeMINA2<-coefficients(lm(minimaA2~timeA2))[2]
      lines(c(sum(data[,1]=="A1")+sum(data[,1]=="B1")+1,sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2")),c(interceptMINA2+slopeMINA2,interceptMINA2+slopeMINA2*sum(data[,1]=="A2")),lty=3)
      interceptMAXA2<-coefficients(lm(maximaA2~timeA2))[1]
      slopeMAXA2<-coefficients(lm(maximaA2~timeA2))[2]
      lines(c(sum(data[,1]=="A1")+sum(data[,1]=="B1")+1,sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2")),c(interceptMAXA2+slopeMAXA2,interceptMAXA2+slopeMAXA2*sum(data[,1]=="A2")),lty=3)
      if(design=="ABAB"){
        lines(c(sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2")+0.5,sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2")+0.5),c(min(data[,2])-5,max(data[,2])+5),lty=2)
        mtext("B",side=3,at=(sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2")+(sum(data[,1]=="B2")+1)/2))
        points(c((length(b21)+1)/2+sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2"),(length(b21)+1)/2+sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2")),c(minb21,maxb21),pch=3,cex=1.3)
        points(c(length(b21)+(length(b22)+1)/2+sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2"),length(b21)+(length(b22)+1)/2+sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2")),c(minb22,maxb22),pch=3,cex=1.3)
        timeB2<-c((length(b21)+1)/2,length(b21)+(length(b22)+1)/2)
        interceptMINB2<-coefficients(lm(minimaB2~timeB2))[1]
        slopeMINB2<-coefficients(lm(minimaB2~timeB2))[2]	
        lines(c(sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2")+1,sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2")+sum(data[,1]=="B2")),c(interceptMINB2+slopeMINB2,interceptMINB2+slopeMINB2*sum(data[,1]=="B2")),lty=3)
        interceptMAXB2<-coefficients(lm(maximaB2~timeB2))[1]
        slopeMAXB2<-coefficients(lm(maximaB2~timeB2))[2]
        lines(c(sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2")+1,sum(data[,1]=="A1")+sum(data[,1]=="B1")+sum(data[,1]=="A2")+sum(data[,1]=="B2")),c(interceptMAXB2+slopeMAXB2,interceptMAXB2+slopeMAXB2*sum(data[,1]=="B2")),lty=3)
      }
    }
  }
  
  if(design=="MBD"){
    N<-ncol(data)/2
    par(mfrow=c(N,1))
    for(it in 1:N){
      if(VAR=="RL"|VAR=="RB"){
        if(dataset=="regular"){
          A<-data[,it*2][data[,(it*2)-1]=="A"]	
          B<-data[,it*2][data[,(it*2)-1]=="B"]
        }
        if(dataset=="trimmed"){
          if(sum(data[,(it*2)-1]=="A")<6|sum(data[,(it*2)-1]=="A")>16){	
            A<-data[,it*2][data[,(it*2)-1]=="A"]
          }
          if(6<=sum(data[,(it*2)-1]=="A")&sum(data[,(it*2)-1]=="A")<=12){
            A<-sort(data[,it*2][data[,(it*2)-1]=="A"])[2:(length(data[,it*2][data[,(it*2)-1]=="A"])-1)]
          }
          if(12<sum(data[,(it*2)-1]=="A")&sum(data[,(it*2)-1]=="A")<=16){
            A<-sort(data[,it*2][data[,(it*2)-1]=="A"])[3:(length(data[,it*2][data[,(it*2)-1]=="A"])-2)]
          }
          if(sum(data[,(it*2)-1]=="B")<6|sum(data[,(it*2)-1]=="B")>16){
            B<-data[,it*2][data[,(it*2)-1]=="B"]
          }
          if(6<=sum(data[,(it*2)-1]=="B")&sum(data[,(it*2)-1]=="B")<=12){
            B<-sort(data[,it*2][data[,(it*2)-1]=="B"])[2:(length(data[,it*2][data[,(it*2)-1]=="B"])-1)]
          }
          if(12<sum(data[,(it*2)-1]=="B")&sum(data[,(it*2)-1]=="B")<=16){
            B<-sort(data[,it*2][data[,(it*2)-1]=="B"])[3:(length(data[,it*2][data[,(it*2)-1]=="B"])-2)] 
          }
        }
        if(VAR=="RL"){
          if (is.null(xlab)){
            xlab=""
          }
          if (is.null(ylab)){
            ylab="Scores"
          }
          plot(x,data[,it*2],xlab=xlab,ylab=ylab,ylim=ylim,pch=16)
          lines(x[data[,(it*2)-1]=="A"],data[,it*2][data[,(it*2)-1]=="A"])
          lines(x[data[,(it*2)-1]=="B"],data[,it*2][data[,(it*2)-1]=="B"])
          lines(c(sum(data[,(it*2)-1]=="A")+0.5,sum(data[,(it*2)-1]=="A")+0.5),c(min(data[,it*2])-5,max(data[,it*2])+5),lty=2)
          mtext("A",side=3,at=(sum(data[,(it*2)-1]=="A")+1)/2)
          mtext("B",side=3,at=(sum(data[,(it*2)-1]=="A")+(sum(data[,(it*2)-1]=="B")+1)/2))
          lines(c(1,(sum(data[,(it*2)-1]=="A"))),c(min(A),min(A)),lty=3)
          lines(c(1,(sum(data[,(it*2)-1]=="A"))),c(max(A),max(A)),lty=3)
          lines(c((sum(data[,(it*2)-1]=="A")+1),MT),c(min(B),min(B)),lty=3)
          lines(c((sum(data[,(it*2)-1]=="A")+1),MT),c(max(B),max(B)),lty=3)
        }
        if(VAR=="RB"){
          if (is.null(xlab)){
            xlab=""
          }
          if (is.null(ylab)){
            ylab="Scores"
          }
          plot(x,data[,it*2],type="n",xlab=xlab,ylab=ylab,ylim=ylim,xaxt="n")
          mtext("A",side=1,at=MT/4)
          mtext("B",side=1,at=MT*3/4)
          lines(c(MT/4,MT/4),c(min(A),max(A)))
          lines(c(MT*3/4,MT*3/4),c(min(B),max(B)))
          if(dataset=="trimmed"){
            if(6<=(sum(data[,(it*2)-1]=="A"))&(sum(data[,(it*2)-1]=="A"))<=12){
              points(MT/4,sort(data[,it*2][data[,(it*2)-1]=="A"])[1],pch=16)
              points(MT/4,sort(data[,it*2][data[,(it*2)-1]=="A"])[length(data[,it*2][data[,(it*2)-1]=="A"])],pch=16)
            }
            if(12<(sum(data[,(it*2)-1]=="A"))&(sum(data[,(it*2)-1]=="A"))<=16){
              points(MT/4,sort(data[,it*2][data[,(it*2)-1]=="A"])[1],pch=16)
              points(MT/4,sort(data[,it*2][data[,(it*2)-1]=="A"])[2],pch=16)
              points(MT/4,sort(data[,it*2][data[,(it*2)-1]=="A"])[length(data[,it*2][data[,(it*2)-1]=="A"])-1],pch=16)
              points(MT/4,sort(data[,it*2][data[,(it*2)-1]=="A"])[length(data[,it*2][data[,(it*2)-1]=="A"])],pch=16)
            }
            if(6<=(sum(data[,(it*2)-1]=="B"))&(sum(data[,(it*2)-1]=="B"))<=12){
              points(MT*3/4,sort(data[,it*2][data[,(it*2)-1]=="B"])[1],pch=16)
              points(MT*3/4,sort(data[,it*2][data[,(it*2)-1]=="B"])[length(data[,it*2][data[,(it*2)-1]=="B"])],pch=16)
            }
            if(12<(sum(data[,(it*2)-1]=="B"))&(sum(data[,(it*2)-1]=="B"))<=16){
              points(MT*3/4,sort(data[,it*2][data[,(it*2)-1]=="B"])[1],pch=16)
              points(MT*3/4,sort(data[,it*2][data[,(it*2)-1]=="B"])[2],pch=16)
              points(MT*3/4,sort(data[,it*2][data[,(it*2)-1]=="B"])[length(data[,it*2][data[,(it*2)-1]=="B"])-1],pch=16)
              points(MT*3/4,sort(data[,it*2][data[,(it*2)-1]=="B"])[length(data[,it*2][data[,(it*2)-1]=="B"])],pch=16)
            }
          }
          if(CL=="mean"){
            CLA<-mean(A)
            CLB<-mean(B)
          }
          if(CL=="median"){
            CLA<-median(A)
            CLB<-median(B)
          }
          if(CL=="bmed"){
            aa<-sort(A)
            bb<-sort(B)
            if(length(aa)<5){
              CLA<-median(A)
            }
            if(length(aa)==5|length(aa)==7|length(aa)==9|length(aa)==11){
              CLA<-(aa[ceiling(length(aa)/2)-1]+aa[ceiling(length(aa)/2)]+aa[ceiling(length(aa)/2)+1])/3
            }
            if(length(aa)>=13&length(aa)%%2==1){
              CLA<-(aa[ceiling(length(aa)/2)-2]+aa[ceiling(length(aa)/2)-1]+aa[ceiling(length(aa)/2)]+aa[ceiling(length(aa)/2)+1] +aa[ceiling(length(aa)/2)+2])/5
            }
            if(length(aa)==6|length(aa)==8|length(aa)==10|length(aa)==12){
              CLA<-1/6*aa[length(aa)/2-1]+1/3*aa[length(aa)/2]+1/3*aa[length(aa)/2+1]+1/6*aa[length(aa)/2+2]
            }
            if(length(aa)>13&length(aa)%%2==0){
              CLA<-1/10*aa[length(aa)/2-2]+1/5*aa[length(aa)/2-1]+1/5*aa[length(aa)/2]+1/5*aa[length(aa)/2+1]+1/5*aa[length(aa)/2+2]+1/10*aa[length(aa)/2+3]
            }
            if(length(bb)<5){
              CLB<-median(B)
            }
            if(length(bb)==5|length(bb)==7|length(bb)==9|length(bb)==11){
              CLB<-(bb[ceiling(length(bb)/2)-1]+bb[ceiling(length(bb)/2)]+bb[ceiling(length(bb)/2)+1])/3
            }
            if(length(bb)>=13&length(bb)%%2==1){
              CLB<-(bb[ceiling(length(bb)/2)-2]+bb[ceiling(length(bb)/2)-1]+bb[ceiling(length(bb)/2)]+bb[ceiling(length(bb)/2)+1]+bb[ceiling(length(bb)/2)+2])/5
            }
            if(length(bb)==6|length(bb)==8|length(bb)==10|length(bb)==12){
              CLB<-1/6*bb[length(bb)/2-1]+1/3*bb[length(bb)/2]+1/3*bb[length(bb)/2+1]+1/6*bb[length(bb)/2+2]
            }
            if(length(bb)>13&length(bb)%%2==0){
              CLB<-1/10*bb[length(bb)/2-2]+1/5*bb[length(bb)/2-1]+1/5*bb[length(bb)/2]+1/5*bb[length(bb)/2+1]+1/5*bb[length(bb)/2+2]+1/10*bb[length(bb)/2+3]
            }
          }  
          if(CL=="trimmean"){
            CLA<-mean(A,trim=tr)	
            CLB<-mean(B,trim=tr)
          }
          if(CL=="mest"){
            hpsi<-function(x,bend=1.28){
              hpsi<-ifelse(abs(x)<=bend,x,bend*sign(x))
              hpsi
            }
            mest<-function(x,bend=1.28,na.rm=F){
              if(na.rm)x<-x[!is.na(x)]
              if(mad(x)==0)stop("MAD=0. The M-estimator cannot be computed.")
              y<-(x-median(x))/mad(x)
              A<-sum(hpsi(y,bend))
              B<-length(x[abs(y)<=bend])
              mest<-median(x)+mad(x)*A/B
              repeat{
                y<-(x-mest)/mad(x)
                A<-sum(hpsi(y,bend))
                B<-length(x[abs(y)<=bend])
                newmest<-mest+mad(x)*A/B
                if(abs(newmest-mest) <.0001)break
                mest<-newmest
              }
              mest
            }
            CLA<-mest(A,bend=tr)	
            CLB<-mest(B,bend=tr)
          }
          lines(c(MT/4-MT/50,MT/4+MT/50),c(CLA,CLA))
          lines(c(MT*3/4-MT/50,MT*3/4+MT/50),c(CLB,CLB))
        }
      }
      if(VAR=="TR"){
        A<-data[,it*2][data[,(it*2)-1]=="A"]	
        B<-data[,it*2][data[,(it*2)-1]=="B"]
        a1<-A[1:ceiling(length(A)/2)]
        a2<-A[(ceiling(length(A)/2)+1):length(A)]
        b1<-B[1:ceiling(length(B)/2)]
        b2<-B[(ceiling(length(B)/2)+1):length(B)]
        if(dataset=="regular"){
          mina1<-min(a1)
          mina2<-min(a2)
          minb1<-min(b1)
          minb2<-min(b2)
          maxa1<-max(a1)
          maxa2<-max(a2)
          maxb1<-max(b1)
          maxb2<-max(b2)
        }
        if(dataset=="trimmed"){
          if(length(a1)<6|length(a1)>16){
            aa1<-a1
          }
          if(6<=length(a1)&length(a1)<=12){
            aa1<-sort(a1)[2:(length(a1)-1)]
          }
          if(12<length(a1)&length(a1)<=16){
            aa1<-sort(a1)[3:(length(a1)-2)]
          }
          if(length(a2)<6|length(a2)>16){
            aa2<-a2
          }
          if(6<=length(a2)&length(a2)<=12){
            aa2<-sort(a2)[2:(length(a2)-1)]
          }
          if(12<length(a2)&length(a2)<=16){
            aa2<-sort(a2)[3:(length(a2)-2)]
          }
          if(length(b1)<6|length(b1)>16){
            bb1<-b1
          }
          if(6<=length(b1)&length(b1)<=12){
            bb1<-sort(b1)[2:(length(b1)-1)]
          }
          if(12<length(b1)&length(b1)<=16){
            bb1<-sort(b1)[3:(length(b1)-2)] 
          }
          if(length(b2)<6|length(b2)>16){
            bb2<-b2
          }
          if(6<=length(b2)&length(b2)<=12){
            bb2<-sort(b2)[2:(length(b2)-1)]
          }
          if(12<length(b2)&length(b2)<=16){
            bb2<-sort(b2)[3:(length(b2)-2)] 
          }
          mina1<-min(aa1)
          mina2<-min(aa2)
          minb1<-min(bb1)
          minb2<-min(bb2)
          maxa1<-max(aa1)
          maxa2<-max(aa2)
          maxb1<-max(bb1)
          maxb2<-max(bb2)
        }
        minimaA<-c(mina1,mina2)
        maximaA<-c(maxa1,maxa2)
        minimaB<-c(minb1,minb2)
        maximaB<-c(maxb1,maxb2)
        if (is.null(xlab)){
          xlab=""
        }
        if (is.null(ylab)){
          ylab="Scores"
        }
        plot(x,data[,it*2],xlab=xlab,ylab=ylab,ylim=ylim,pch=16)
        lines(c(sum(data[,(it*2)-1]=="A")+0.5,sum(data[,(it*2)-1]=="A")+0.5),c(min(data[,it*2])-5,max(data[,it*2])+5),lty=2)	
        mtext("A",side=3,at=(sum(data[,(it*2)-1]=="A")+1)/2)	
        mtext("B",side=3,at=(sum(data[,(it*2)-1]=="A")+(sum(data[,(it*2)-1]=="B")+1)/2))
        points(c((length(a1)+1)/2,(length(a1)+1)/2),c(mina1,maxa1),pch=3,cex=1.3)
        points(c(length(a1)+(length(a2)+1)/2,length(a1)+(length(a2)+1)/2),c(mina2,maxa2),pch=3,cex=1.3)
        points(c((length(b1)+1)/2+sum(data[,(it*2)-1]=="A"),(length(b1)+1)/2+sum(data[,(it*2)-1]=="A")),c(minb1,maxb1),pch=3,cex=1.3)
        points(c(length(b1)+(length(b2)+1)/2+sum(data[,(it*2)-1]=="A"),length(b1)+(length(b2)+1)/2+sum(data[,(it*2)-1]=="A")),c(minb2,maxb2),pch=3,cex=1.3)
        timeA<-c((length(a1)+1)/2,length(a1)+(length(a2)+1)/2)
        timeB<-c((length(b1)+1)/2,length(b1)+(length(b2)+1)/2)
        interceptMINA<-coefficients(lm(minimaA~timeA))[1]
        slopeMINA<-coefficients(lm(minimaA~timeA))[2]
        interceptMAXA<-coefficients(lm(maximaA~timeA))[1]
        slopeMAXA<-coefficients(lm(maximaA~timeA))[2]
        interceptMINB<-coefficients(lm(minimaB~timeB))[1]
        slopeMINB<-coefficients(lm(minimaB~timeB))[2]
        interceptMAXB<-coefficients(lm(maximaB~timeB))[1]
        slopeMAXB<-coefficients(lm(maximaB~timeB))[2]
        lines(c(1,sum(data[,(it*2)-1]=="A")),c(interceptMINA+slopeMINA,interceptMINA+slopeMINA*(sum(data[,(it*2)-1]=="A"))),lty=3)
        lines(c(1,sum(data[,(it*2)-1]=="A")),c(interceptMAXA+slopeMAXA,interceptMAXA+slopeMAXA*(sum(data[,(it*2)-1]=="A"))),lty=3)
        lines(c(sum(data[,(it*2)-1]=="A")+1,MT),c(interceptMINB+slopeMINB,interceptMINB+slopeMINB*(sum(data[,1]=="B"))),lty=3)
        lines(c(sum(data[,(it*2)-1]=="A")+1,MT),c(interceptMAXB+slopeMAXB,interceptMAXB+slopeMAXB*(sum(data[,(it*2)-1]=="B"))),lty=3)
      }
    }
  
    if(VAR=="RL"|VAR=="TR"){
      if (is.null(xlab)){
        xlab="Measurement Times"
      }
      title(xlab=xlab,pch=16)
    }    
    if(VAR=="RB"){
      if (is.null(xlab)){
        xlab="Range Bars"
      }
      title(xlab=xlab,pch=16)
    }    
  
    par(mfrow=c(1,1))
  
  }

}
