% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.chebyshev.R
\name{chebyshev}
\alias{chebyshev}
\title{Chebyshev distance}
\usage{
chebyshev(X, Y)
}
\arguments{
\item{X}{[matrix or SparseHist] If matrix, dim = ( nrow = n_samples, ncol =
n_features)}

\item{Y}{[matrix or SparseHist] If matrix, dim = ( nrow = n_samples, ncol =
n_features)}
}
\value{
[float] value of distance
}
\description{
Compute Chebyshev distance between two dataset or SparseHist X and Y
}
\examples{
X = base::cbind( stats::rnorm(2000) , stats::rnorm(2000)  )
Y = base::cbind( stats::rnorm(2000,mean=2)  , stats::rnorm(2000) )
bw = base::c(0.1,0.1)
muX = SBCK::SparseHist( X , bw )
muY = SBCK::SparseHist( Y , bw )

## The four are equals
d = SBCK::chebyshev(  X ,   Y )
d = SBCK::chebyshev(muX ,   Y )
d = SBCK::chebyshev(  X , muY )
d = SBCK::chebyshev(muX , muY )

}
