% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppp.PrePostProcessing.R
\name{PrePostProcessing}
\alias{PrePostProcessing}
\title{PrePostProcessing base class}
\description{
Base class to pre/post process data before/after a bias correction
}
\details{
This base class can be considered as the identity pre-post processing, and
is used to be herited by others pre/post processing class. The key ideas are:\cr
- A PrePostProcessing based class contains a bias correction method, initalized
  by the `bc_method` argument, always available for all herited class\cr
- The `pipe` keyword is a list of pre/post processing class, applied one after
  the other.\cr

Try with an example, start with a dataset similar to tas/pr:\cr
>>> XY = SBCK::dataset_like_tas_pr(2000)\cr
>>> X0 = XY$X0\cr
>>> X1 = XY$X1\cr
>>> Y0 = XY$Y0\cr

The first column is Gaussian, but the second is an exponential law with a Dirac
mass at 0, represented the 0 of precipitations. For a quantile mapping
correction in the calibration period, we just apply\cr
>>> qm = SBCK::QM$new()\cr
>>> qm$fit(Y0,X0)\cr
>>> Z0 = qm$predict(X0)\cr

Now, if we want to pre-post process with the SSR method (0 are replaced by
random values between 0 (excluded) and the minimal non zero value), we write:\cr
>>> ppp = SBCK::PPPSSR$new( bc_method = QM , cols = 2 )\cr
>>> ppp$fit(Y0,X0)\cr
>>> Z0 = ppp$predict(X0)\cr

The SSR approach is applied only on the second column (the precipitation), and
the syntax is the same than for a simple bias correction method.\cr

Imagine now that we want to apply the SSR, and to ensure the positivity of CDFt
for precipitation, we also want to use the LogLinLink pre-post processing
method. This can be done with the following syntax:\cr
>>> ppp = PPPLogLinLink$new( bc_method = CDFt , cols = 2 ,\cr
>>>                          pipe = list(PPPSSR) , \cr
>>>                          pipe_kwargs = list( list(cols = 2) ) )\cr
>>> ppp$fit(Y0,X0,X1)\cr
>>> Z = ppp$predict(X1,X0)\cr

With this syntax, the pre processing operation is
PPPLogLinLink$transform(PPPSSR$transform(data)) and post processing operation
PPPSSR$itransform(PPPLogLinLink$itransform(bc_data)). So the formula can read
from right to left (as the mathematical composition). Note it is equivalent
to define:\cr
>>> ppp = PrePostProcessing$new( bc_method = CDFt,\cr
>>>                              pipe = list(PPPLogLinLink,PPPSSR),\cr
>>>                              pipe_kwargs = list( list(cols=2) , list(cols=2) ) )\cr
}
\examples{
## Start with data
XY = SBCK::dataset_like_tas_pr(2000)
X0 = XY$X0
X1 = XY$X1
Y0 = XY$Y0

## Define pre/post processing method
ppp = PrePostProcessing$new( bc_method = CDFt,
                             pipe = list(PPPLogLinLink,PPPSSR),
                             pipe_kwargs = list( list(cols=2) , list(cols=2) ) )

## Bias correction
ppp$fit(Y0,X0,X1)
Z = ppp$predict(X1,X0)

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PrePostProcessing-new}{\code{PrePostProcessing$new()}}
\item \href{#method-PrePostProcessing-transform}{\code{PrePostProcessing$transform()}}
\item \href{#method-PrePostProcessing-itransform}{\code{PrePostProcessing$itransform()}}
\item \href{#method-PrePostProcessing-fit}{\code{PrePostProcessing$fit()}}
\item \href{#method-PrePostProcessing-predict}{\code{PrePostProcessing$predict()}}
\item \href{#method-PrePostProcessing-clone}{\code{PrePostProcessing$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PrePostProcessing-new"></a>}}
\if{latex}{\out{\hypertarget{method-PrePostProcessing-new}{}}}
\subsection{Method \code{new()}}{
Create a new PrePostProcessing object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PrePostProcessing$new(
  bc_method = NULL,
  bc_method_kwargs = list(),
  pipe = list(),
  pipe_kwargs = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bc_method}}{The bias correction method}

\item{\code{bc_method_kwargs}}{Dict of keyword arguments passed to bc_method}

\item{\code{pipe}}{list of others PrePostProcessing class to pipe}

\item{\code{pipe_kwargs}}{list of list of keyword arguments passed to each
elements of pipe}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `PrePostProcessing` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PrePostProcessing-transform"></a>}}
\if{latex}{\out{\hypertarget{method-PrePostProcessing-transform}{}}}
\subsection{Method \code{transform()}}{
Transformation applied to data before the bias correction. Just the
identity for this class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PrePostProcessing$transform(X)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{[matrix: n_samples * n_features]}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Xt [matrix: n_samples * n_features]
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PrePostProcessing-itransform"></a>}}
\if{latex}{\out{\hypertarget{method-PrePostProcessing-itransform}{}}}
\subsection{Method \code{itransform()}}{
Transformation applied to data after the bias correction. Just the
identity for this class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PrePostProcessing$itransform(Xt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Xt}}{[matrix: n_samples * n_features]}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
X [matrix: n_samples * n_features]
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PrePostProcessing-fit"></a>}}
\if{latex}{\out{\hypertarget{method-PrePostProcessing-fit}{}}}
\subsection{Method \code{fit()}}{
Apply the pre processing and fit the bias correction method. If X1 is
NULL, the method is considered as stationary
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PrePostProcessing$fit(Y0, X0, X1 = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y0}}{[matrix: n_samples * n_features] Observations in calibration}

\item{\code{X0}}{[matrix: n_samples * n_features] Model in calibration}

\item{\code{X1}}{[matrix: n_samples * n_features] Model in projection}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PrePostProcessing-predict"></a>}}
\if{latex}{\out{\hypertarget{method-PrePostProcessing-predict}{}}}
\subsection{Method \code{predict()}}{
Predict the correction, apply pre-processing before, and post-processing
after
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PrePostProcessing$predict(X1 = NULL, X0 = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X1}}{[matrix: n_samples * n_features or NULL] Model in projection}

\item{\code{X0}}{[matrix: n_samples * n_features or NULL] Model in calibration}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[matrix or list] Return the matrix of correction of X1 if X0 is
                         NULL (and vice-versa), else return a list
                         containing Z1 and Z0, the corrections of X1 and X0
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PrePostProcessing-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PrePostProcessing-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PrePostProcessing$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
