% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyhedra-lib.R
\docType{class}
\name{PolyhedronState.class}
\alias{PolyhedronState.class}
\title{Polyhedron State}
\format{\code{\link{R6Class}} object.}
\usage{
PolyhedronState.class
}
\description{
This abstract class provide the basis from which polyhedron state class derivate.
}
\section{Fields}{

\describe{
\item{\code{errors}}{Errors string}

\item{\code{source}}{polyhedron definition source}

\item{\code{file.id}}{polyhedron file id}
}}

\section{Methods}{

\describe{
  \item{\code{addError(current.error)}}{Adds an error to the error string and log it as info}
  \item{\code{scrape()}}{Scrapes the polyhedra folder files}
  \item{\code{getSolid()}}{returns the object corresponding to the solid}
  \item{\code{applyTransformationMatrix(transformation.matrix)}}{Apply transformation matrix to polyhedron}
  \item{\code{buildRGL(transformation.matrix)}}{creates a RGL representation of the object}
  \item{\code{exportToXML()}}{Gets an XML representation out of the polyhedron object}
}
}

\keyword{datasets}
