% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addTitle.R
\name{addTitle}
\alias{addTitle}
\alias{addTitle.docx}
\alias{addTitle.pptx}
\title{Add a title}
\usage{
addTitle(doc, value, ...)

\method{addTitle}{docx}(doc, value, level = 1, ...)

\method{addTitle}{pptx}(doc, value, ...)
}
\arguments{
\item{doc}{document object}

\item{value}{\code{"character"} value to use as title text}

\item{...}{further arguments passed to or from other methods..}

\item{level}{\code{"integer"} positive value to use as
heading level. 1 for title1, 2 for title2, etc. Default to 1.}
}
\value{
a document object
}
\description{
Add a title into a document object
}
\details{
Function addTitle when used with docx object needs to know which
style correspond to which title level (1 ; 1.1 ; 1.1.1 ; etc.).
When a template is read, ReporteRs tries to guess what are the available
styles (english, french, chinese, etc.). If styles for titles has not
been detected you will see the following error when addTitle is being called:

\code{You must defined title styles via map_title first.}

As the error message points out, you have to call the function `map_title` to
indicate which available styles are meant to be used as title styles.

To add a title into a pptx object you
only have to specify the text to use as title. There is no level concept.
}
\examples{

# Title example for MS Word -------
\donttest{
doc.filename = "ex_add_title.docx"
doc <- docx()
doc <- addTitle( doc, "Title example 1", level = 1 )
doc <- addTitle( doc, "Title example 2", level = 1 )
writeDoc( doc, file = doc.filename )
}
\donttest{
# Title example for PowerPoint -------
doc.filename = "ex_add_title.pptx"
doc <- pptx()
doc <- addSlide(doc, "Title and Content")
doc <- addTitle(doc, "Title example")
writeDoc( doc, file = doc.filename )
}
}
\seealso{
\code{\link{map_title}}
}
