% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDocument.R
\name{addDocument}
\alias{addDocument}
\alias{addDocument.docx}
\title{Add an external document into a document object}
\usage{
addDocument(doc, filename, ...)

\method{addDocument}{docx}(doc, filename, ...)
}
\arguments{
\item{doc}{document object}

\item{filename}{\code{"character"} value, complete filename
of the external file}

\item{...}{further arguments passed to other methods}
}
\value{
a document object
}
\description{
Add an external document into a document object
}
\details{
ReporteRs does only copy the document as an external file. Headers and footers are also
imported and displayed. This function is not to be used to merge documents.
}
\examples{
\donttest{
doc.filename <- "addDocument_example.docx"
# set default font size to 10
options( "ReporteRs-fontsize" = 10 )

doc2embed <- docx( )
img.file <- file.path( Sys.getenv("R_HOME"),
                      "doc", "html", "logo.jpg" )
if( file.exists(img.file) && requireNamespace("jpeg", quietly = TRUE) ){
  dims <- attr( jpeg::readJPEG(img.file), "dim" )

  doc2embed <- addImage(doc2embed, img.file,
                       width = dims[2]/72, height = dims[1]/72)
  writeDoc( doc2embed, file = "external_file.docx" )

  doc <- docx( )
  doc <- addDocument( doc, filename = "external_file.docx" )
  writeDoc( doc, file = doc.filename )
}
}
}
\seealso{
\code{\link{docx}}
}
