/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.docx4r.tools;

import java.math.BigInteger;

import org.docx4j.wml.TblWidth;
import org.docx4j.wml.TcMar;

public class Format {
	

	
	public static TcMar getMargins(int paddingBottom, int paddingTop, int paddingLeft, int paddingRight){
	    TcMar mar = new TcMar();
	    
	    if( paddingBottom > 0 ){
		    TblWidth bottomWidth = new TblWidth();
		    bottomWidth.setW(BigInteger.valueOf( (long)(paddingBottom*20)) );
		    bottomWidth.setType("dxa");
		    mar.setBottom(bottomWidth);
	    }
	    if( paddingTop > 0 ){
		    TblWidth topWidth = new TblWidth();
		    topWidth.setW(BigInteger.valueOf( (long)(paddingTop*20)) );
		    topWidth.setType("dxa");
		    mar.setTop(topWidth);
	    }
	    if( paddingLeft > 0 ){
		    TblWidth leftWidth = new TblWidth();
		    leftWidth.setW(BigInteger.valueOf( (long)(paddingLeft*20)) );
		    leftWidth.setType("dxa");
		    mar.setLeft(leftWidth);
	    }
	    
	    if( paddingRight > 0 ){
		    TblWidth rightWidth = new TblWidth();
		    rightWidth.setW(BigInteger.valueOf( (long)(paddingRight*20)) );
		    rightWidth.setType("dxa");
		    mar.setRight(rightWidth);
	    }
	    
	    return mar;
	}

}
