% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FlexTable.R
\name{FlexTable}
\alias{FlexTable}
\title{FlexTable creation}
\usage{
FlexTable(data, numrow, numcol, header.columns = TRUE, add.rownames = FALSE,
  body.cell.props = cellProperties(), body.par.props = parProperties(padding
  = 0), body.text.props = textProperties(),
  header.cell.props = cellProperties(),
  header.par.props = parProperties(padding = 0),
  header.text.props = textProperties(font.weight = "bold"))
}
\arguments{
\item{data}{(a \code{data.frame} or \code{matrix} object) to add}

\item{numrow}{number of row in the table body. Mandatory if data is missing.}

\item{numcol}{number of col in the table body. Mandatory if data is missing.}

\item{header.columns}{logical value - should the colnames be included in the table
as table headers. If FALSE, no headers will be printed unless you
use \code{\link{addHeaderRow}}.}

\item{add.rownames}{logical value - should the row.names be included in the table.}

\item{body.cell.props}{default cells formatting properties for table body}

\item{body.par.props}{default paragraphs formatting properties for table body}

\item{body.text.props}{default text formatting properties for table body}

\item{header.cell.props}{default cells formatting properties for table headers}

\item{header.par.props}{default paragraphs formatting properties for table headers}

\item{header.text.props}{default text formatting properties for table headers}
}
\description{
Create an object of class \code{FlexTable}.

FlexTable can be manipulated so that almost any formatting can be specified.

An API is available to let you manipulate (format, add text, merge cells, etc.)
your FlexTable. A FlexTable is made of 3 parts: header, body and footer. To insert
headers and footers rows with eventually merged cells, see
\code{\link{addHeaderRow}} and \code{\link{addFooterRow}}.

Formating can be done on cells, paragraphs and text (borders, colors, fonts, etc.)
, see \code{\link{alterFlexTable}}.
}
\details{
The classical workflow would be to create a FlexTable, to add headers rows
(see \code{\link{addHeaderRow}}) and eventually footers
rows (see \code{\link{addFooterRow}}).


A FlexTable lets you add text in cells and modify cells, paragraphs and text
properties. Text can be added with operator \code{[<-}.
Text, paragraphs and cells properties can be also modified with operator \code{[<-}.
(see \code{\link{alterFlexTable}}).


Below list of functions to use with \code{FlexTable} objects:


\strong{Text formatting}

Apply a \code{\link{textProperties}} object to a subset of the
FlexTable. Use the operator \code{[<-}. The \code{textProperties}
object will be used to format all text from selected cells. See
\code{\link{alterFlexTable}}.

\strong{Text adding}

Add text with operator \code{[<-}. Text can be added just after
the last text in the cell or as a new paragraph. Format can also
be specified. Text can also be a \code{\link{pot}} object if the
text format is complex.

\strong{Paragraph formatting}

Apply a \code{\link{parProperties}} object to a subset of the
FlexTable. Use the operator \code{[<-}. The \code{parProperties}
object will be used to format all paragraphs from selected cells. See
\code{\link{alterFlexTable}}.

\strong{Cell formatting}

Apply a \code{\link{cellProperties}} object to a subset of the
FlexTable. Use the operator \code{[<-}. The \code{cellProperties}
object will be used to format selected cells. See \code{\link{alterFlexTable}}.

\strong{Borders}

Apply borders scheme to a FlexTable with function \code{\link{setFlexTableBorders}}.

Set a border to a selection in a FlexTable with the operator \code{[<-} and an object
of class \code{\link{borderProperties}}. Don't forget to specify argument \code{side}.
See \code{\link{alterFlexTable}}.


\strong{Cell background colors}

Applies background colors to cells. See \code{\link{setFlexTableBackgroundColors}}.

Alternate row colors (zebra striping) with function \code{\link{setZebraStyle}}.

Applies background colors to rows with function \code{\link{setRowsColors}}.

Applies background colors to columns with function \code{\link{setColumnsColors}}.


\strong{Cell merge}

Span rows within columns with function \code{\link{spanFlexTableRows}}.

Span columns within rows with function \code{\link{spanFlexTableColumns}}.

\strong{Columns widths}

Set columns widths with function \code{\link{setFlexTableWidths}}.
}
\examples{
#
#####################################################################

# Create a FlexTable with data.frame mtcars, display rownames
# use different formatting properties for header and body
MyFTable = FlexTable( data = mtcars, add.rownames = TRUE, 
  header.cell.props = cellProperties( background.color = "#00557F" ), 
  header.text.props = textProperties( color = "white", 
    font.size = 11, font.weight = "bold" ), 
  body.text.props = textProperties( font.size = 10 )
)
# zebra stripes - alternate colored backgrounds on table rows
MyFTable = setZebraStyle( MyFTable, odd = "#E1EEf4", even = "white" )

# applies a border grid on table
MyFTable = setFlexTableBorders(MyFTable,
  inner.vertical = borderProperties( color="#0070A8", style="solid" ),
  inner.horizontal = borderNone(),
  outer.vertical = borderProperties( color = "#006699", 
	style = "solid", width = 2 ),
  outer.horizontal = borderProperties( color = "#006699", 
	style = "solid", width = 2 )
)
#####################################################################

# set default font size to 10
options( "ReporteRs-fontsize" = 10 )

# a summary of mtcars
dataset = aggregate( mtcars[, c("disp", "mpg", "wt")]
  , by = mtcars[, c("cyl", "gear", "carb")]
  , FUN = mean )
dataset = dataset[ order(dataset$cyl, dataset$gear, dataset$carb), ]


# set cell padding defaut to 2
baseCellProp = cellProperties( padding = 2 )

# Create a FlexTable with data.frame dataset
MyFTable = FlexTable( data = dataset
  , body.cell.props = baseCellProp
  , header.cell.props = baseCellProp
  , header.par.props = parProperties(text.align = "right" )
)

# set columns widths (inch)
MyFTable = setFlexTableWidths( MyFTable, 
	widths = c(0.5, 0.5, 0.5, 0.7, 0.7, 0.7) )

# span successive identical cells within column 1, 2 and 3
MyFTable = spanFlexTableRows( MyFTable, j = 1,
	runs = as.character( dataset$cyl ) )
MyFTable = spanFlexTableRows( MyFTable, j = 2, 
	runs = as.character( dataset$gear ) )
MyFTable = spanFlexTableRows( MyFTable, j = 3, 
	runs = as.character( dataset$carb ) )

# overwrites some text formatting properties
MyFTable[dataset$wt < 3, 6] = textProperties( color="#003366")
MyFTable[dataset$mpg < 20, 5] = textProperties( color="#993300")

# overwrites some paragraph formatting properties
MyFTable[, 1:3] = parProperties(text.align = "center")
MyFTable[, 4:6] = parProperties(text.align = "right")


Footnote1 = Footnote(  )

par1 = pot("About this reference", textBold( ) )
par2 = pot("Omni ab coalitos pro malivolus obsecrans graviter 
cum perquisitor perquisitor pericula saepeque inmunibus coalitos ut.", 
  textItalic(font.size = 8) )
Footnote1 = addParagraph( Footnote1, set_of_paragraphs( par1, par2 ), 
  parProperties(text.align = "justify"))

Footnote1 = addParagraph( Footnote1, 
	set_of_paragraphs( "list item 1", "list item 2" ), 
  parProperties(text.align = "left", list.style = "ordered"))

an_rscript = RScript( text = "ls()
x = rnorm(10)" )
Footnote1 = addParagraph( Footnote1, an_rscript )

MyFTable[1, 1, newpar = TRUE] = pot("a note", 
  footnote = Footnote1, format = textBold(color="gray") )

pot_link = pot(" (link example)", textProperties( color = "cyan" ), 
  hyperlink = "http://www.wikipedia.org/" )

MyFTable[1, 1, to = "header"] = pot_link

# applies a border grid on table
MyFTable = setFlexTableBorders( MyFTable, footer=TRUE
  , inner.vertical = borderProperties( color = "#666666" )
  , inner.horizontal = borderProperties( color = "#666666" )
  , outer.vertical = borderProperties( width = 2, color = "#666666" )
  , outer.horizontal = borderProperties( width = 2, color = "#666666" )
)
data = cor( cor(mtcars) )

pal = c( "#D73027", "#F46D43", "#FDAE61", "#FEE08B", 
  "#D9EF8B", "#A6D96A", "#66BD63", "#1A9850" )
mycut = cut( data, 
  breaks = c(-1,-0.75,-0.5,-0.25,0,0.25,0.5,0.75,1),
  include.lowest = TRUE, label = FALSE )
mycolors = pal[ mycut ]

MyFTable = FlexTable( round(data, 3), add.rownames = TRUE )

# set computed colors
MyFTable = setFlexTableBackgroundColors( MyFTable, 
  j = seq_len(ncol(data)) + 1, 
  colors = mycolors )

# cosmetics
MyFTable = setFlexTableBackgroundColors( MyFTable, i = 1, 
  colors = "gray", to = "header" )
MyFTable[1, , to = "header"] = textBold(color="white")

MyFTable = setFlexTableBackgroundColors( MyFTable, j = 1, 
	colors = "gray" )
MyFTable[,1] = textBold(color="white")

MyFTable = setFlexTableBorders( MyFTable,
  inner.vertical = borderProperties( style = "dashed", 
	color = "white" ),
  inner.horizontal = borderProperties( style = "dashed", 
	color = "white"  ),
  outer.vertical = borderProperties( width = 2, color = "white"  ),
  outer.horizontal = borderProperties( width = 2, color = "white"  )
)



data( iris )
iris = iris[1:10, c(5, 1:4)]

default_text = textProperties( font.size = 11 )
note_text = chprop(default_text, 
	vertical.align = "superscript", color = "blue")

iris_ft = FlexTable( data = iris, header.columns = FALSE )
iris_ft = addHeaderRow( iris_ft, 
	value = c("", "Measures" ), colspan = c( 4, 1 ) )
iris_ft = addHeaderRow( iris_ft, 
	value = gsub( "\\\\.", " ", names( iris ) ) )
iris_ft[2, 2, newpar = TRUE ] = "Hi there"
iris_ft[2, 1, to="header"] = pot("* this is a note", note_text )


iris_ft = spanFlexTableRows( iris_ft, j = "Species", 
	runs = as.character( iris$Species ) )
iris_ft = setFlexTableBorders( iris_ft, 
  inner.vertical = borderProperties( style = "none" ), 
  inner.horizontal = borderProperties( width = 1 ), 
  outer.vertical = borderProperties( width = 0 ), 
  outer.horizontal = borderProperties( width = 2 ), 
  footer = TRUE
)
}
\seealso{
\code{\link{addHeaderRow}}, \code{\link{addFooterRow}}, \code{\link{setFlexTableWidths}}
, \code{\link{alterFlexTable}}, \code{\link{setFlexTableBorders}}
, \code{\link{spanFlexTableRows}}, \code{\link{spanFlexTableColumns}}
, \code{\link{setRowsColors}}, \code{\link{setColumnsColors}}, \code{\link{setZebraStyle}}
, \code{\link{setFlexTableBackgroundColors}}, \code{\link{pot}}
, \code{\link{addFlexTable}}
}

