package org.lysis.reporters.formats;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

import javax.xml.bind.JAXBElement;

import org.docx4j.dml.CTColor;
import org.docx4j.dml.CTPositiveFixedPercentage;
import org.docx4j.dml.CTSRgbColor;
import org.docx4j.dml.CTSolidColorFillProperties;
import org.docx4j.wml.CTShd;

public class ColorProperties {
	private int r_;
	private int g_;
	private int b_;
	private int a_;
	
	public ColorProperties(int r, int g, int b, int a ){
		r_ = r;
		g_ = g;
		b_ = b;
		a_ = a;
	}
	
	private static String gethex(int n) {
	  return String.format("%02X", n);
	}
	
	private String gethexcolorcode(){
		String out = gethex(r_) + gethex(g_) + gethex(b_) ;
		return out;
	}
	
	public String getHexCode(){
		return "#" + gethexcolorcode();
	}
	
	public String getrgba(){
		double alpha = (double)(a_);
		alpha /= 255.0;
		DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
		decimalFormatSymbols.setDecimalSeparator('.');
		DecimalFormat decimalFormat = new DecimalFormat("#.##", decimalFormatSymbols);
		return "rgba(" + r_ + ", " + g_ + ", " + b_ + ", " + decimalFormat.format(alpha) + ")" ;
	}
	
	public CTSolidColorFillProperties getSolidFill(){
		
		CTSolidColorFillProperties solidfill = new CTSolidColorFillProperties();
		solidfill.setSrgbClr(getCTSRgbColor());
		return solidfill;
	}
	
	public CTColor getCTColor(){
		CTColor prop = new CTColor();
        prop.setSrgbClr( getCTSRgbColor() );
		return prop;		  
	}
	
	private CTSRgbColor getCTSRgbColor(){
		org.docx4j.dml.ObjectFactory dmlObjectFactory = new org.docx4j.dml.ObjectFactory();
		CTSRgbColor rgb = new CTSRgbColor();
		rgb.setVal(new byte[]{(byte)r_, (byte)g_, (byte)b_});
		CTPositiveFixedPercentage positivefixedpercentage = new CTPositiveFixedPercentage();
		positivefixedpercentage.setVal((int) (a_ / 255.0 * 100000));
        JAXBElement<org.docx4j.dml.CTPositiveFixedPercentage> positivefixedpercentageWrapped = dmlObjectFactory.createCTSRgbColorAlpha(positivefixedpercentage); 
        rgb.getEGColorTransform().add( positivefixedpercentageWrapped); 
        return rgb;
	}
	
	public CTShd getCT_Shd(){
		CTShd shd = new CTShd();
		shd.setFill(gethexcolorcode());
		return shd;
	}
	public org.docx4j.wml.Color getColor(){
		org.docx4j.wml.Color col = new org.docx4j.wml.Color();
		col.setVal(gethexcolorcode());
		return col;
	}
	
}
