/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.html4r.elements;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedHashMap;

import org.lysis.reporters.formats.ParProperties;
import org.lysis.reporters.html4r.tools.Format;
import org.lysis.reporters.tools.HTML4R;

public class SVGContent implements HTML4R{
	private String svg_str;
	private ParProperties parProperties;

	public SVGContent(ParProperties pp, String file) throws IOException{
		parProperties = pp;
		svg_str = "";
		BufferedReader in = new BufferedReader(new FileReader( file ));
		String s;
		while( (s = in.readLine()) != null) {
			svg_str += s;
		}
		in.close();
	}


	@Override
	public String getHTML() {
		LinkedHashMap<String, String> ppr = parProperties.get_html_pp();
		String pStart = "<div style=\"" + Format.getJSString(ppr) + "\">";
		String pStop = "</div>";
		return pStart + svg_str + pStop;
	}

	@Override
	public String getCSS() {
		return "";
	}

	@Override
	public String getJS() {
		return "";
	}

	@Override
	public boolean hasJS() {
		return false;
	}

	@Override
	public boolean hasCSS() {
		return false;
	}

	@Override
	public boolean hasHTML() {
		return true;
	}


}
