/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.img;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.xml.bind.JAXBContext;
import org.apache.commons.codec.binary.Base64;
import org.docx4j.XmlUtils;
import org.docx4j.dml.CTTransform2D;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.lysis.reporters.html4r.tools.Format;
import org.lysis.reporters.img.Imageutils;
import org.lysis.reporters.tools.DocComponent;
import org.lysis.reporters.tools.HTML4R;
import org.lysis.reporters.tools.PPTX4R;
import org.pptx4j.jaxb.Context;
import org.pptx4j.pml.Pic;

public class Image
extends DocComponent
implements HTML4R,
PPTX4R {
    private byte[] image_bytes;
    private String filename;
    private float width_in;
    private float height_in;
    private long width_emu;
    private long height_emu;
    private static String PICTURE = "<p:pic xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:p=\"http://schemas.openxmlformats.org/presentationml/2006/main\"> <p:nvPicPr><p:cNvPr id=\"${element_id}\" name=\"Picture ${element_id}\" /><p:cNvPicPr><a:picLocks noChangeAspect=\"1\"/></p:cNvPicPr><p:nvPr><p:ph idx=\"${idx}\"/></p:nvPr></p:nvPicPr><p:blipFill><a:blip r:embed=\"${rEmbedId}\" cstate=\"print\"/><a:stretch><a:fillRect/></a:stretch></p:blipFill><p:spPr><a:xfrm><a:off x=\"${offx}\" y=\"${offy}\"/><a:ext cx=\"${cx}\" cy=\"${cy}\"/></a:xfrm><a:prstGeom prst=\"rect\"><a:avLst/></a:prstGeom></p:spPr></p:pic>";

    public Image(String filename, float w, float h) throws Exception {
        this.filename = filename;
        File file = new File(filename);
        this.image_bytes = Imageutils.convertImageToByteArray(file);
        this.width_in = w;
        this.height_in = h;
        this.width_emu = (long)(this.width_in * 914400.0f);
        this.height_emu = (long)(this.height_in * 914400.0f);
        this.setExt(this.width_emu, this.height_emu);
    }

    @Override
    public long next_id() {
        return this.unique_id + 2L;
    }

    @Override
    public Object get_pptx_elt() throws Exception {
        BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((OpcPackage)this.pptx_mlp, (Part)this.slidePart, (byte[])this.image_bytes);
        Relationship rel = this.slidePart.addTargetPart((Part)imagePart);
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("element_id", String.valueOf(this.shape_id));
        mappings.put("rEmbedId", rel.getId());
        mappings.put("idx", String.valueOf(this.unique_id));
        mappings.put("cx", "" + this.width_emu);
        mappings.put("cy", "" + this.height_emu);
        mappings.put("offx", "" + this.getOffx());
        mappings.put("offy", "" + this.getOffy());
        Object o = XmlUtils.unmarshallFromTemplate((String)PICTURE, mappings, (JAXBContext)Context.jcPML, Pic.class);
        return o;
    }

    public void add_img_to_pptx(String rel_id) throws Exception {
        BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((OpcPackage)this.pptx_mlp, (Part)this.slidePart, (byte[])this.image_bytes);
        this.slidePart.addTargetPart((Part)imagePart, rel_id);
    }

    public void add_img_to_docx(String rel_id) throws Exception {
        BinaryPartAbstractImage.createImagePart((WordprocessingMLPackage)this.docx_mlp, (byte[])this.image_bytes);
    }

    public R get_docx_run() throws Exception {
        BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((WordprocessingMLPackage)this.docx_mlp, (byte[])this.image_bytes);
        Inline inline = imagePart.createImageInline(this.filename, "image", (int)this.unique_id, (int)this.unique_id + 1, false);
        CTTransform2D xfrm = this.getXfrm();
        xfrm.getExt().setCx(this.width_emu);
        xfrm.getExt().setCy(this.height_emu);
        inline.getGraphic().getGraphicData().getPic().getSpPr().setXfrm(xfrm);
        inline.setExtent(xfrm.getExt());
        R run = new R();
        Drawing drawing = new Drawing();
        run.getContent().add(drawing);
        drawing.getAnchorOrInline().add(inline);
        return run;
    }

    public P get_docx_elt() throws Exception {
        BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((WordprocessingMLPackage)this.docx_mlp, (byte[])this.image_bytes);
        Inline inline = imagePart.createImageInline(this.filename, "image", (int)this.unique_id, (int)this.unique_id + 1, false);
        CTTransform2D xfrm = this.getXfrm();
        xfrm.getExt().setCx(this.width_emu);
        xfrm.getExt().setCy(this.height_emu);
        inline.getGraphic().getGraphicData().getPic().getSpPr().setXfrm(xfrm);
        inline.setExtent(xfrm.getExt());
        P paragraph = new P();
        paragraph.setPPr(this.getPPr());
        this.addBookmark(paragraph);
        R run = new R();
        paragraph.getContent().add(run);
        Drawing drawing = new Drawing();
        run.getContent().add(drawing);
        drawing.getAnchorOrInline().add(inline);
        return paragraph;
    }

    @Override
    public String getHTML() {
        String out = "";
        LinkedHashMap<String, String> ppr = this.getParProperties().get_html_pp();
        String pStart = "<p style=\"" + Format.getJSString(ppr) + "\">";
        String pStop = "</p>";
        out = String.valueOf(out) + pStart + this.getRunHTML() + pStop;
        return out;
    }

    public String getRunHTML() {
        String out = "<img src=\"data:image/png;base64," + new String(Base64.encodeBase64((byte[])this.image_bytes)) + "\" width=\"" + (int)(this.width_in * 72.0f) + "\" height=\"" + (int)(this.height_in * 72.0f) + "\">";
        return out;
    }

    @Override
    public String getCSS() {
        return "";
    }

    @Override
    public String getJS() {
        return "";
    }

    @Override
    public boolean hasJS() {
        return false;
    }

    @Override
    public boolean hasCSS() {
        return false;
    }

    @Override
    public boolean hasHTML() {
        return true;
    }
}

