/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.docs;

import java.util.HashMap;
import java.util.List;
import org.docx4j.dml.CTTextBody;
import org.docx4j.dml.CTTransform2D;
import org.docx4j.openpackaging.parts.PresentationML.SlidePart;
import org.lysis.reporters.docs.pptx4R;
import org.lysis.reporters.img.DrawingML;
import org.lysis.reporters.img.Image;
import org.lysis.reporters.pptx4r.elements.Date;
import org.lysis.reporters.pptx4r.elements.Footer;
import org.lysis.reporters.pptx4r.elements.SlideNumber;
import org.lysis.reporters.pptx4r.elements.SubTitle;
import org.lysis.reporters.pptx4r.elements.Title;
import org.lysis.reporters.pptx4r.elements.template.LayoutDescription;
import org.lysis.reporters.pptx4r.elements.template.MasterLayoutProperties;
import org.lysis.reporters.tables.FlexTable;
import org.lysis.reporters.text.CodeBlock;
import org.lysis.reporters.text.ParagraphSet;
import org.lysis.reporters.text.RScript;
import org.lysis.reporters.tools.Debug;
import org.lysis.reporters.tools.EMU;
import org.pptx4j.pml.Pic;
import org.pptx4j.pml.Shape;
import org.pptx4j.pml.Sld;

public class SlideContent {
    public static int undefined = -1;
    public static int donotexists = 0;
    public static int isfilled = 1;
    public static int noproblem = 2;
    public static int noroomleft = 3;
    public static int undefdimension = 4;
    private SlidePart slidePart;
    private pptx4R itsPPTX;
    private long uidShape;
    private LayoutDescription layoutDescription;
    private int slideIndex;
    private int max_shape;
    private int num_shape;
    private int freeshapeid;
    private HashMap<Integer, Boolean> headersFilled;
    private int ol_id = 1;
    private boolean lastIsParagraph = false;

    public SlideContent(SlidePart sp, pptx4R doc, LayoutDescription _layoutDescription) throws Exception {
        this.slidePart = sp;
        this.itsPPTX = doc;
        this.uidShape = 0L;
        this.freeshapeid = 0;
        this.num_shape = 0;
        this.layoutDescription = _layoutDescription;
        this.max_shape = this.layoutDescription.getContentSize();
        this.layoutDescription.fixMissingXfrm(doc.getMasterLayoutProperties());
        if (Debug.debug) {
            System.err.println("SlideContent - max shape " + this.max_shape);
        }
        this.headersFilled = this.layoutDescription.getIsFilledHeaderModel();
    }

    public void setSlideIndex(int index) {
        this.slideIndex = index;
    }

    public int getNextShapeIndex() {
        return this.num_shape;
    }

    public int getmax_shape() {
        return this.max_shape;
    }

    public int addTitle(String title) {
        boolean isCRT = false;
        if (!this.layoutDescription.hasTitle() && this.layoutDescription.hasCrttitle()) {
            isCRT = true;
        }
        if (Debug.debug) {
            System.err.println("addTitle hasTitle:" + this.layoutDescription.hasTitle() + " hasCrttitle : " + this.layoutDescription.hasCrttitle());
        }
        if (!isCRT) {
            if (!this.layoutDescription.hasTitle()) {
                return donotexists;
            }
            if (this.headersFilled.get(MasterLayoutProperties.TITLE).booleanValue()) {
                return isfilled;
            }
            try {
                Shape sTitle = (Shape)Title.getShape(this.layoutDescription.getIdx_title(), this.uidShape + 1L, title);
                ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sTitle);
                this.headersFilled.put(MasterLayoutProperties.TITLE, true);
            }
            catch (Exception e) {
                return undefined;
            }
        }
        if (this.headersFilled.get(MasterLayoutProperties.CRTTITLE).booleanValue()) {
            return isfilled;
        }
        try {
            Shape sTitle = (Shape)Title.getShape(this.layoutDescription.getIdx_crttitle(), this.uidShape + 1L, title);
            ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sTitle);
            this.headersFilled.put(MasterLayoutProperties.CRTTITLE, true);
        }
        catch (Exception e) {
            return undefined;
        }
        ++this.uidShape;
        this.lastIsParagraph = false;
        return noproblem;
    }

    public int addSubTitle(String title) {
        if (!this.layoutDescription.hasSubtitle()) {
            return donotexists;
        }
        if (this.headersFilled.get(MasterLayoutProperties.SUBTITLE).booleanValue()) {
            return isfilled;
        }
        try {
            Shape sTitle = (Shape)SubTitle.getShape(this.layoutDescription.getIdx_subtitle(), this.uidShape + 1L, title);
            ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sTitle);
            this.headersFilled.put(MasterLayoutProperties.SUBTITLE, true);
        }
        catch (Exception e) {
            return undefined;
        }
        ++this.uidShape;
        this.lastIsParagraph = false;
        return noproblem;
    }

    public int addDate(String date) {
        if (!this.layoutDescription.hasDate()) {
            return donotexists;
        }
        if (this.headersFilled.get(MasterLayoutProperties.DATE).booleanValue()) {
            return isfilled;
        }
        try {
            Shape sDate = (Shape)Date.getShape(this.layoutDescription.getIdx_date(), this.uidShape + 1L, date);
            ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sDate);
            this.headersFilled.put(MasterLayoutProperties.DATE, true);
        }
        catch (Exception e) {
            return undefined;
        }
        ++this.uidShape;
        this.lastIsParagraph = false;
        return noproblem;
    }

    public int addSlideNumber(String slidenumber) {
        if (!this.layoutDescription.hasSlideNumber()) {
            return donotexists;
        }
        if (this.headersFilled.get(MasterLayoutProperties.SLIDENUMBER).booleanValue()) {
            return isfilled;
        }
        try {
            Shape sSlideNumber = (Shape)SlideNumber.getShape(this.layoutDescription.getIdx_slidenumber(), this.uidShape + 1L, slidenumber);
            ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sSlideNumber);
            this.headersFilled.put(MasterLayoutProperties.SLIDENUMBER, true);
        }
        catch (Exception e) {
            return undefined;
        }
        ++this.uidShape;
        this.lastIsParagraph = false;
        return noproblem;
    }

    public int addSlideNumber() {
        return this.addSlideNumber(String.valueOf(this.slideIndex));
    }

    public int addFooter(String footer) {
        if (!this.layoutDescription.hasFooter()) {
            return donotexists;
        }
        if (this.headersFilled.get(MasterLayoutProperties.FOOTER).booleanValue()) {
            return isfilled;
        }
        try {
            Shape sFooter = (Shape)Footer.getShape(this.layoutDescription.getIdx_footer(), this.uidShape + 1L, footer);
            ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sFooter);
            this.headersFilled.put(MasterLayoutProperties.FOOTER, true);
        }
        catch (Exception e) {
            return undefined;
        }
        ++this.uidShape;
        this.lastIsParagraph = false;
        return noproblem;
    }

    private boolean roomLeft() {
        return this.max_shape - this.num_shape > 0;
    }

    public int add(Image img, float offx, float offy, boolean free_layout) throws Exception {
        img.setPPTXMLPackage(this.itsPPTX.getBaseDocument());
        img.setPPTXSlidePart(this.slidePart);
        img.setOff(EMU.getEMUFromInch(offx), EMU.getEMUFromInch(offy));
        if (!free_layout) {
            img.setUID(this.uidShape + 1L);
            img.setShapeID(this.uidShape + 1L);
            Pic shape = (Pic)img.get_pptx_elt();
            ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(shape);
            this.uidShape = (int)img.next_id();
            ++this.num_shape;
        } else {
            ++this.freeshapeid;
            img.setUID((long)this.freeshapeid + this.uidShape);
            img.setShapeID((long)this.freeshapeid + this.uidShape);
            Pic shape = (Pic)img.get_pptx_elt();
            ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(shape);
        }
        this.lastIsParagraph = false;
        return noproblem;
    }

    public int add_png(String[] files, String[] names, double[] widths, double[] heights) throws Exception {
        int i = 0;
        while (i < files.length) {
            Image img = new Image(files[i], (float)widths[i], (float)heights[i]);
            img.setPPTXMLPackage(this.itsPPTX.getBaseDocument());
            img.setPPTXSlidePart(this.slidePart);
            img.add_img_to_pptx(names[i]);
            ++i;
        }
        return noproblem;
    }

    public String getNextRelID() {
        return this.slidePart.relationships.getNextId();
    }

    public int add(DrawingML d) throws Exception {
        if (!this.roomLeft()) {
            return noroomleft;
        }
        d.setPPTXMLPackage(this.itsPPTX.getBaseDocument());
        d.setPPTXSlidePart(this.slidePart);
        d.setXfrm(this.layoutDescription.getContent(this.num_shape).getXfrm());
        d.setUID(this.uidShape + 1L);
        d.setShapeID(this.uidShape + 1L);
        ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().addAll(d.get_pptx_elt());
        ++this.num_shape;
        ++this.uidShape;
        this.lastIsParagraph = false;
        return noproblem;
    }

    public int add(DrawingML d, double offx, double offy, double width, double height) throws Exception {
        ++this.freeshapeid;
        d.setPPTXMLPackage(this.itsPPTX.getBaseDocument());
        d.setPPTXSlidePart(this.slidePart);
        d.setOff(EMU.getEMUFromInch(offx), EMU.getEMUFromInch(offy));
        d.setExt(EMU.getEMUFromInch(width), EMU.getEMUFromInch(height));
        d.setUID((long)this.freeshapeid + this.uidShape);
        d.setShapeID((long)this.freeshapeid + this.uidShape);
        ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().addAll(d.get_pptx_elt());
        this.lastIsParagraph = false;
        return noproblem;
    }

    public int[] getShapeDimensions() {
        int[] out = new int[]{-1, -1, -1, -1};
        if (!this.roomLeft()) {
            return out;
        }
        CTTransform2D xfrm = this.layoutDescription.getContent(this.num_shape).getXfrm();
        out[0] = (int)xfrm.getOff().getX();
        out[1] = (int)xfrm.getOff().getY();
        out[2] = (int)xfrm.getExt().getCx();
        out[3] = (int)xfrm.getExt().getCy();
        return out;
    }

    public int add(FlexTable obj) throws Exception {
        if (!this.roomLeft()) {
            return noroomleft;
        }
        obj.setPPTXMLPackage(this.itsPPTX.getBaseDocument());
        obj.setPPTXSlidePart(this.slidePart);
        obj.setXfrm(this.layoutDescription.getContent(this.num_shape).getXfrm());
        obj.setUID(this.uidShape + 1L);
        obj.setShapeID(this.uidShape + 1L);
        obj.setTableWidth(obj.getCx());
        ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(obj.get_pptx_elt());
        ++this.num_shape;
        ++this.uidShape;
        this.lastIsParagraph = false;
        return noproblem;
    }

    public int add(FlexTable obj, double offx, double offy, double width, double height) throws Exception {
        ++this.freeshapeid;
        obj.setPPTXMLPackage(this.itsPPTX.getBaseDocument());
        obj.setPPTXSlidePart(this.slidePart);
        obj.setOff(EMU.getEMUFromInch(offx), EMU.getEMUFromInch(offy));
        obj.setExt(EMU.getEMUFromInch(width), EMU.getEMUFromInch(height));
        obj.setUID((long)this.freeshapeid + this.uidShape);
        obj.setShapeID((long)this.freeshapeid + this.uidShape);
        obj.setTableWidth(EMU.getEMUFromInch(width));
        ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(obj.get_pptx_elt());
        this.lastIsParagraph = false;
        return noproblem;
    }

    private void incr_ol_id(ParagraphSet obj) {
        if (obj.getParProperties() != null && obj.getParProperties().getListStyle().equals("ordered") && obj.getParProperties().getLevel() < 2) {
            this.ol_id += obj.size();
        }
    }

    private void init_ol_id() {
        this.ol_id = 1;
    }

    public int add(ParagraphSet obj, boolean restartNumbering) throws Exception {
        if (!this.roomLeft()) {
            return noroomleft;
        }
        obj.setPPTXMLPackage(this.itsPPTX.getBaseDocument());
        obj.setPPTXSlidePart(this.slidePart);
        obj.setXfrm(this.layoutDescription.getContent(this.num_shape).getXfrm());
        obj.setUID(this.uidShape + 1L);
        obj.setShapeID(this.uidShape + 1L);
        if (restartNumbering) {
            this.init_ol_id();
        }
        Shape s = obj.get_pptx_elt(this.itsPPTX.getNumberingDefinition(), this.ol_id);
        if (this.layoutDescription.getContent(this.num_shape).isList() && obj.getParProperties() == null) {
            s.getTxBody().setLstStyle(this.layoutDescription.getContent(this.num_shape).getListStyle());
        }
        Shape smodel = this.layoutDescription.getContent(this.num_shape).getShape();
        smodel.setTxBody(s.getTxBody());
        ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(smodel);
        ++this.num_shape;
        ++this.uidShape;
        this.incr_ol_id(obj);
        this.lastIsParagraph = true;
        return noproblem;
    }

    public int append(ParagraphSet obj, boolean restartNumbering) throws Exception {
        List shapes = ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame();
        obj.setPPTXMLPackage(this.itsPPTX.getBaseDocument());
        obj.setPPTXSlidePart(this.slidePart);
        if (shapes.size() < 1) {
            return this.add(obj, restartNumbering);
        }
        if (!this.lastIsParagraph) {
            return isfilled;
        }
        if (restartNumbering) {
            this.init_ol_id();
        }
        CTTextBody ss = obj.get_pptx_parset(this.itsPPTX.getNumberingDefinition(), this.ol_id);
        Shape currentShape = (Shape)shapes.get(shapes.size() - 1);
        currentShape.getTxBody().getP().addAll(ss.getP());
        this.incr_ol_id(obj);
        this.lastIsParagraph = true;
        return noproblem;
    }

    public int add(ParagraphSet obj, double offx, double offy, double width, double height, boolean restartNumbering) throws Exception {
        ++this.freeshapeid;
        obj.setPPTXMLPackage(this.itsPPTX.getBaseDocument());
        obj.setPPTXSlidePart(this.slidePart);
        obj.setOff(EMU.getEMUFromInch(offx), EMU.getEMUFromInch(offy));
        obj.setExt(EMU.getEMUFromInch(width), EMU.getEMUFromInch(height));
        obj.setRot(0);
        obj.setUID((long)this.freeshapeid + this.uidShape);
        obj.setShapeID((long)this.freeshapeid + this.uidShape);
        if (restartNumbering) {
            this.init_ol_id();
        }
        ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(obj.get_pptx_elt(this.itsPPTX.getNumberingDefinition(), this.ol_id));
        this.incr_ol_id(obj);
        this.lastIsParagraph = true;
        return noproblem;
    }

    public int add(RScript obj) throws Exception {
        if (!this.roomLeft()) {
            return noroomleft;
        }
        obj.setPPTXMLPackage(this.itsPPTX.getBaseDocument());
        obj.setPPTXSlidePart(this.slidePart);
        obj.setXfrm(this.layoutDescription.getContent(this.num_shape).getXfrm());
        obj.setUID(this.uidShape + 1L);
        obj.setShapeID(this.uidShape + 1L);
        Shape smodel = this.layoutDescription.getContent(this.num_shape).getShape();
        smodel.setTxBody(obj.get_pptx_elt().getTxBody());
        ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(smodel);
        ++this.num_shape;
        ++this.uidShape;
        this.lastIsParagraph = true;
        return noproblem;
    }

    public int append(RScript obj) throws Exception {
        List shapes = ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame();
        obj.setPPTXMLPackage(this.itsPPTX.getBaseDocument());
        obj.setPPTXSlidePart(this.slidePart);
        if (shapes.size() < 1) {
            return this.add(obj);
        }
        if (!this.lastIsParagraph) {
            return isfilled;
        }
        CTTextBody ss = obj.get_pptx_parset();
        Shape currentShape = (Shape)shapes.get(shapes.size() - 1);
        currentShape.getTxBody().getP().addAll(ss.getP());
        this.lastIsParagraph = true;
        return noproblem;
    }

    public int add(RScript obj, double offx, double offy, double width, double height) throws Exception {
        ++this.freeshapeid;
        obj.setPPTXMLPackage(this.itsPPTX.getBaseDocument());
        obj.setPPTXSlidePart(this.slidePart);
        obj.setOff(EMU.getEMUFromInch(offx), EMU.getEMUFromInch(offy));
        obj.setExt(EMU.getEMUFromInch(width), EMU.getEMUFromInch(height));
        obj.setRot(0);
        obj.setUID((long)this.freeshapeid + this.uidShape);
        obj.setShapeID((long)this.freeshapeid + this.uidShape);
        ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(obj.get_pptx_elt());
        this.lastIsParagraph = false;
        return noproblem;
    }

    public int add(CodeBlock obj) throws Exception {
        if (!this.roomLeft()) {
            return noroomleft;
        }
        obj.setPPTXMLPackage(this.itsPPTX.getBaseDocument());
        obj.setPPTXSlidePart(this.slidePart);
        obj.setXfrm(this.layoutDescription.getContent(this.num_shape).getXfrm());
        obj.setUID(this.uidShape + 1L);
        obj.setShapeID(this.uidShape + 1L);
        Shape smodel = this.layoutDescription.getContent(this.num_shape).getShape();
        smodel.setTxBody(obj.get_pptx_elt().getTxBody());
        ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(smodel);
        ++this.num_shape;
        ++this.uidShape;
        this.lastIsParagraph = true;
        return noproblem;
    }

    public int append(CodeBlock obj) throws Exception {
        List shapes = ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame();
        obj.setPPTXMLPackage(this.itsPPTX.getBaseDocument());
        obj.setPPTXSlidePart(this.slidePart);
        if (shapes.size() < 1) {
            return this.add(obj);
        }
        if (!this.lastIsParagraph) {
            return isfilled;
        }
        CTTextBody ss = obj.get_pptx_parset();
        Shape currentShape = (Shape)shapes.get(shapes.size() - 1);
        currentShape.getTxBody().getP().addAll(ss.getP());
        this.lastIsParagraph = true;
        return noproblem;
    }

    public int add(CodeBlock obj, double offx, double offy, double width, double height) throws Exception {
        ++this.freeshapeid;
        obj.setPPTXMLPackage(this.itsPPTX.getBaseDocument());
        obj.setPPTXSlidePart(this.slidePart);
        obj.setOff(EMU.getEMUFromInch(offx), EMU.getEMUFromInch(offy));
        obj.setExt(EMU.getEMUFromInch(width), EMU.getEMUFromInch(height));
        obj.setRot(0);
        obj.setUID((long)this.freeshapeid + this.uidShape);
        obj.setShapeID((long)this.freeshapeid + this.uidShape);
        ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(obj.get_pptx_elt());
        this.lastIsParagraph = false;
        return noproblem;
    }

    public String getLayoutName() {
        return this.layoutDescription.getLabel();
    }
}

