% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/writeDoc.bsdoc.R
\name{writeDoc.bsdoc}
\alias{writeDoc.bsdoc}
\title{Write a \code{bsdoc} object in a html file}
\usage{
\method{writeDoc}{bsdoc}(doc, file, ...)
}
\arguments{
\item{doc}{\code{\link{bsdoc}} object that has to be written.}

\item{file}{single character value, name of the html file to write.}

\item{...}{further arguments, not used.}
}
\value{
the function a character vector containing generated html documents filenames.
}
\description{
Write the \code{\link{bsdoc}} object in '.html' files located in a specified directory.

bootstrap files will be copied in the directory if directory does not exist.
}
\examples{
\dontrun{
doc.filename = "writeDoc_bsdoc/example.html"

# set default font size to 11
options( "ReporteRs-fontsize" = 11 )

doc = bsdoc( )

# Write the object
writeDoc( doc, file = doc.filename )
}
}
\seealso{
\code{\link{bsdoc}}, \code{\link{writeDoc}}
}

