% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/addPlot.bsdoc.R
\name{addPlot.bsdoc}
\alias{addPlot.bsdoc}
\title{Add a plot into an bsdoc object}
\usage{
\method{addPlot}{bsdoc}(doc, fun, pointsize = getOption("ReporteRs-fontsize"),
  vector.graphic = T, width = 6, height = 6,
  fontname = getOption("ReporteRs-default-font"),
  par.properties = parCenter(padding = 5), ...)
}
\arguments{
\item{doc}{Object of class \code{bsdoc} where paragraph has to be added}

\item{fun}{plot function. The function will be executed to produce graphics.
For \code{grid} or \code{lattice} or \code{ggplot} object, the function
should just be print and an extra argument x should specify the object
to plot. For traditionnal plots, the function should contain plot instructions. See examples.}

\item{pointsize}{the default pointsize of plotted text in pixels, default to 12.}

\item{vector.graphic}{logical scalar, default to FALSE. If TRUE, vector graphics
are produced instead of PNG images. If TRUE, vector graphics are
RaphaelJS instructions(transformed as SVG).}

\item{width}{plot width in inches (default value is 6).}

\item{height}{plot height in inches (default value is 6).}

\item{fontname}{the default font family to use, default to getOption("ReporteRs-default-font").}

\item{par.properties}{paragraph formatting properties of the paragraph that contains plot(s). An object of class \code{\link{parProperties}}}

\item{...}{arguments for \code{fun}.}
}
\value{
an object of class \code{\link{bsdoc}}.
}
\description{
Add a plot into the \code{bsdoc} object.
}
\examples{
\dontrun{
doc.filename = "addPlot_bsdoc/example.html"

# set default font size to 11
options( "ReporteRs-fontsize" = 11 )

doc = bsdoc( )

doc = addTitle( doc, "Title example 1", level = 1 )
# Add a base plot
# set vector.graphic to FALSE if Word version
#   used to read the file is <= 2007
doc = addPlot( doc, fun = plot
  , x = rnorm( 100 ), y = rnorm (100 )
  , main = "base plot main title"
  , vector.graphic = TRUE
  , width = 5, height = 7
  , par.properties = parProperties(text.align = "left")
)


doc = addTitle( doc, "Title example 2", level = 1 )
# load ggplot2
if( requireNamespace("ggplot2", quietly = TRUE) ){

  # create a ggplot2 plot
  myplot = ggplot2::qplot(Sepal.Length, Petal.Length, data = iris
    , color = Species, size = Petal.Width, alpha = I(0.7) )

  # Add myplot into object doc
  #   myplot is assigned to argument 'x' because function 'print' on ggplot
  #   objects is expecting argument 'x'.
  doc = addPlot( doc = doc, fun = print, x = myplot )
}


doc = addTitle( doc, "Title example 3", level = 1 )
###########################################################
# Create lm.D9, a lm object
ctl = c(4.17,5.58,5.18,6.11,4.50,4.61,5.17,4.53,5.33,5.14)
trt = c(4.81,4.17,4.41,3.59,5.87,3.83,6.03,4.89,4.32,4.69)
group = gl(2, 10, 20, labels = c("Ctl","Trt"))
weight = c(ctl, trt)
lm.D9 = lm(weight ~ group)

# add the 6 plots into the document
doc = addPlot( doc, plot, x = lm.D9, width = 6, height = 7 )

# Write the object
writeDoc( doc, file = doc.filename )
}
}
\seealso{
\code{\link{bsdoc}}, \code{\link{addPlot}}
, \code{\link{add.plot.interactivity}}
}

