% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/addDocument.docx.R
\name{addDocument.docx}
\alias{addDocument.docx}
\title{Add external document into a docx object}
\usage{
\method{addDocument}{docx}(doc, filename, ...)
}
\arguments{
\item{doc}{Object of class \code{\link{docx}} where external image has to be added}

\item{filename}{\code{"character"} value, complete filename of the external
file (a Word document with \code{docx} extension).}

\item{...}{further arguments, not used.}
}
\value{
an object of class \code{\link{docx}}.
}
\description{
Add external document into a \code{\link{docx}} object.
}
\details{
The rendering of embedded documents is made by Word. ReporteRs does only copy
the content of the external file in the document.

When adding an external docx file into a docx object, styles of the external
file are imported into the docx object. If a style exists in the docx object,
Word will use the style of the docx object.
}
\examples{
\dontrun{
doc.filename = "addDocument_example.docx"
if( .Platform$OS.type == "windows" ){
	# set default font size to 10
	options( "ReporteRs-fontsize" = 10 )
	
	doc2embed = docx( )
	img.file = file.path( Sys.getenv("R_HOME"), "doc", "html", "logo.jpg" )
	doc2embed = addImage(doc2embed, img.file )
	writeDoc( doc2embed, file = "external_file.docx" )
	
	doc = docx( )
	doc = addDocument( doc, filename = "external_file.docx" )
	writeDoc( doc, file = doc.filename )
}
}
}
\seealso{
\code{\link{docx}}, \code{\link{addDocument}}
}

