/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.lists;

import java.math.BigInteger;
import org.docx4j.dml.CTTextAutonumberBullet;
import org.docx4j.dml.CTTextCharBullet;
import org.docx4j.dml.CTTextParagraphProperties;
import org.docx4j.dml.STTextAutonumberScheme;
import org.docx4j.dml.TextFont;
import org.docx4j.wml.Jc;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.Lvl;
import org.docx4j.wml.NumFmt;
import org.docx4j.wml.NumberFormat;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;

public class LevelDefinition {
    private double indent_left;
    private double indent_hanging;
    private String textalign;
    private String format;
    private String pattern;
    private int level;
    private String cssClassName;

    public LevelDefinition(double indent_left, double indent_hanging, String textalign, String format, String pattern, int level) {
        this.indent_left = indent_left;
        this.indent_hanging = indent_hanging;
        this.textalign = textalign;
        this.format = format;
        this.pattern = pattern;
        this.level = level;
    }

    public String getCssClassName() {
        return this.cssClassName;
    }

    public void setCssClassName(String cssClassName) {
        this.cssClassName = cssClassName;
    }

    public double getIndent_left() {
        return this.indent_left;
    }

    public void setIndent_left(double indent_left) {
        this.indent_left = indent_left;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public double getIndent_hanging() {
        return this.indent_hanging;
    }

    public void setIndent_hanging(double indent_hanging) {
        this.indent_hanging = indent_hanging;
    }

    public String getAlignment() {
        return this.textalign;
    }

    public void setAlignment(String textalign) {
        this.textalign = textalign;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    private STTextAutonumberScheme get_pptx_NumberFormat() {
        if (this.format.equals("decimal")) {
            return STTextAutonumberScheme.ARABIC_PERIOD;
        }
        if (this.format.equals("upperRoman")) {
            return STTextAutonumberScheme.ROMAN_UC_PAREN_BOTH;
        }
        if (this.format.equals("lowerRoman")) {
            return STTextAutonumberScheme.ROMAN_LC_PERIOD;
        }
        if (this.format.equals("upperLetter")) {
            return STTextAutonumberScheme.ALPHA_UC_PERIOD;
        }
        if (this.format.equals("lowerLetter")) {
            return STTextAutonumberScheme.ALPHA_LC_PERIOD;
        }
        return STTextAutonumberScheme.ARABIC_PERIOD;
    }

    public void set_pptx_scheme(CTTextParagraphProperties parProperties, int startNumbering) {
        int mar_left = (int)((this.getIndent_left() + this.getIndent_hanging()) * 914400.0);
        parProperties.setMarL(Integer.valueOf(mar_left));
        if (this.getLevel() > 0) {
            parProperties.setLvl(Integer.valueOf(this.getLevel()));
        }
        parProperties.setIndent(Integer.valueOf((int)(-this.getIndent_hanging() * 914400.0)));
        if (this.isOrdered()) {
            CTTextAutonumberBullet autonum = new CTTextAutonumberBullet();
            autonum.setType(this.get_pptx_NumberFormat());
            parProperties.setBuAutoNum(autonum);
            if (startNumbering > 1 && this.getLevel() < 1) {
                autonum.setStartAt(Integer.valueOf(startNumbering));
            }
        } else if (this.isUnordered()) {
            CTTextCharBullet textBullet = new CTTextCharBullet();
            Integer pitchFamily = 0;
            Integer charset = 0;
            TextFont tf = new TextFont();
            if (this.format.equals("square")) {
                pitchFamily = 2;
                charset = 2;
                tf.setTypeface("Wingdings");
                textBullet.setChar("\u00a7");
            } else if (this.format.equals("circle")) {
                pitchFamily = 49;
                charset = 0;
                tf.setTypeface("Courier New");
                textBullet.setChar("o");
            } else {
                pitchFamily = 34;
                charset = 0;
                tf.setTypeface("Arial");
                textBullet.setChar("\u2022");
            }
            tf.setCharset(Byte.valueOf(charset.byteValue()));
            tf.setPitchFamily(Byte.valueOf(pitchFamily.byteValue()));
            parProperties.setBuFont(tf);
            parProperties.setBuChar(textBullet);
        }
    }

    public boolean isOrdered() {
        return this.format.equals("decimal") || this.format.equals("upperRoman") || this.format.equals("lowerRoman") || this.format.equals("upperLetter") || this.format.equals("lowerLetter");
    }

    public boolean isUnordered() {
        return this.format.equals("circle") || this.format.equals("disc") || this.format.equals("square");
    }

    private String getCSSNumberFormat() {
        if (this.format.equals("decimal")) {
            return ", decimal";
        }
        if (this.format.equals("upperRoman")) {
            return ", upper-roman";
        }
        if (this.format.equals("lowerRoman")) {
            return ", lower-roman";
        }
        if (this.format.equals("upperLetter")) {
            return ", upper-alpha";
        }
        if (this.format.equals("lowerLetter")) {
            return ", lower-alpha";
        }
        if (this.format.equals("circle")) {
            return ", circle";
        }
        if (this.format.equals("disc")) {
            return ", disc";
        }
        if (this.format.equals("square")) {
            return ", square";
        }
        return "circle";
    }

    private NumberFormat getNumberFormat() {
        if (this.format.equals("decimal")) {
            return NumberFormat.DECIMAL;
        }
        if (this.format.equals("upperRoman")) {
            return NumberFormat.UPPER_ROMAN;
        }
        if (this.format.equals("lowerRoman")) {
            return NumberFormat.LOWER_ROMAN;
        }
        if (this.format.equals("upperLetter")) {
            return NumberFormat.UPPER_LETTER;
        }
        if (this.format.equals("lowerLetter")) {
            return NumberFormat.LOWER_LETTER;
        }
        return NumberFormat.BULLET;
    }

    private String getDocxPattern() {
        if (this.format.equals("decimal")) {
            return this.pattern;
        }
        if (this.format.equals("upperRoman")) {
            return this.pattern;
        }
        if (this.format.equals("lowerRoman")) {
            return this.pattern;
        }
        if (this.format.equals("upperLetter")) {
            return this.pattern;
        }
        if (this.format.equals("lowerLetter")) {
            return this.pattern;
        }
        if (this.format.equals("disc")) {
            return "\u25cf ";
        }
        if (this.format.equals("circle")) {
            return "\u25cb ";
        }
        if (this.format.equals("square")) {
            return "\u220e ";
        }
        return "\u25cf ";
    }

    public Lvl getLvl() throws Exception {
        Lvl lvl = new Lvl();
        lvl.setIlvl(BigInteger.valueOf(this.level));
        Jc alignment = new Jc();
        if (this.textalign.equals("left")) {
            alignment.setVal(JcEnumeration.LEFT);
        } else if (this.textalign.equals("center")) {
            alignment.setVal(JcEnumeration.CENTER);
        } else if (this.textalign.equals("right")) {
            alignment.setVal(JcEnumeration.RIGHT);
        } else if (this.textalign.equals("justify")) {
            alignment.setVal(JcEnumeration.BOTH);
        }
        lvl.setLvlJc(alignment);
        PPr parProperties = new PPr();
        PPrBase.Ind ind = new PPrBase.Ind();
        ind.setLeft(BigInteger.valueOf((int)((this.indent_left + this.indent_hanging) * 1440.0)));
        ind.setHanging(BigInteger.valueOf((int)(this.indent_hanging * 1440.0)));
        parProperties.setInd(ind);
        lvl.setPPr(parProperties);
        NumFmt nf = new NumFmt();
        nf.setVal(this.getNumberFormat());
        lvl.setNumFmt(nf);
        Lvl.LvlText lt = new Lvl.LvlText();
        lt.setVal(this.getDocxPattern());
        lvl.setLvlText(lt);
        Lvl.Start start = new Lvl.Start();
        start.setVal(BigInteger.valueOf(1L));
        lvl.setStart(start);
        return lvl;
    }

    public String getCounterName(int list_id) {
        String CSSSuffix = String.valueOf(list_id) + "-" + (this.level + 1);
        return "counter-" + CSSSuffix;
    }

    public int getPaddingLeft() {
        int dtbefore = (int)(this.indent_left * 72.0);
        int dtpaddingleft = dtbefore + (int)(this.indent_hanging * 72.0);
        return dtpaddingleft;
    }

    public String getHTMLCSS(int list_id) {
        String CSSSuffix = String.valueOf(list_id) + "-" + (this.level + 1);
        String counterDefExtraArg = this.getCSSNumberFormat();
        String CounterName = "counter-" + CSSSuffix;
        String CSSClassName = "";
        String CSSCounterIncrement = "";
        String CSSListformat = "";
        if (this.isUnordered()) {
            CSSClassName = "ul-" + CSSSuffix;
            CSSCounterIncrement = "";
        } else {
            CSSClassName = "ol-" + CSSSuffix;
            CSSCounterIncrement = "counter-increment: " + CounterName + ";";
        }
        String tempcss = this.pattern.replaceAll("(%){1}([0-9]){1}", "counter(counter-" + list_id + "-$2" + counterDefExtraArg + ") ");
        CSSListformat = "content: \"" + tempcss.replaceAll("(counter\\(([a-z0-9\\-\\,\\s])+\\)){1}", "\" $1 \"") + "\";";
        int dtbefore = (int)(this.indent_left * 72.0);
        String out = "";
        out = String.valueOf(out) + "." + CSSClassName + " dt::before{" + CSSCounterIncrement + CSSListformat + "position: absolute;left:" + dtbefore + "px" + ";" + "}";
        out = String.valueOf(out) + "." + CSSClassName + " dt {position: relative;font-weight: normal;}";
        return out;
    }
}

