/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.pptx4r.elements.layouts;

import org.docx4j.dml.CTTransform2D;
import org.pptx4j.pml.Shape;

public class ShapeDescription {
    private long idx;
    private CTTransform2D xfrm;
    private String shapeType = "undefined";

    public ShapeDescription(Shape s) {
        try {
            this.shapeType = s.getNvSpPr().getNvPr().getPh().getType().value();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.idx = s.getNvSpPr().getNvPr().getPh().getIdx();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.setValues(s);
    }

    private void setValues(Shape s) {
        try {
            this.xfrm = s.getSpPr().getXfrm();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDefaultXfrm(CTTransform2D xfrm) {
        this.xfrm = xfrm;
    }

    public long getIdx() {
        return this.idx;
    }

    public CTTransform2D getXfrm() throws NullPointerException {
        if (this.xfrm == null) {
            throw new NullPointerException("No Xfrm defined");
        }
        return this.xfrm;
    }

    public String getShapeType() {
        return this.shapeType;
    }

    public boolean isContent() {
        return this.getShapeType().equals("body") || this.getShapeType().equals("obj") || this.getShapeType().equals("title") || this.getShapeType().equals("pic") || this.getShapeType().equals("tbl") || this.getShapeType().equals("subTitle") || this.getShapeType().equals("dt") || this.getShapeType().equals("sldNum") || this.getShapeType().equals("ftr") || this.getShapeType().equals("undefined");
    }

    public String toString() {
        return "type=" + this.shapeType + "\t{offx:" + this.xfrm.getOff().getX() + ",offy:" + this.xfrm.getOff().getY() + ",extx:" + this.xfrm.getExt().getCx() + ",exty:" + this.xfrm.getExt().getCy() + "}";
    }
}

