/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.docs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.apache.commons.lang.StringEscapeUtils;
import org.lysis.reporters.html4r.elements.MenuBar;
import org.lysis.reporters.html4r.elements.RAPHAELGraphics;
import org.lysis.reporters.html4r.elements.TOC;
import org.lysis.reporters.html4r.elements.Title;
import org.lysis.reporters.img.Image;
import org.lysis.reporters.tables.FlexTable;
import org.lysis.reporters.text.ParagraphSet;
import org.lysis.reporters.text.RScript;
import org.lysis.reporters.tools.HTML4R;

public class HTMLPageContent {
    public static int error = 0;
    public static int noproblem = 1;
    public static int fileproblem = 2;
    private TOC titles;
    private String title;
    private MenuBar mb;
    private LinkedHashMap<Integer, HTML4R> content;
    private int ncontent;
    private String charset;
    private Vector<String> cssfiles;
    private Vector<String> jsfiles;
    private Vector<String> jscodes;
    private Vector<String> csscodes;

    public HTMLPageContent(String title, String charset) throws IOException {
        this.title = title;
        this.titles = new TOC(this.title);
        this.content = new LinkedHashMap();
        this.ncontent = 0;
        this.setCharset(charset);
        this.cssfiles = new Vector();
        this.jsfiles = new Vector();
        this.jscodes = new Vector();
        this.csscodes = new Vector();
    }

    private int addHTML4R(HTML4R elt) {
        if (elt instanceof Title) {
            this.titles.addTitle((Title)elt);
        }
        this.content.put(this.ncontent, elt);
        if (elt.hasJS()) {
            this.jscodes.add(elt.getJS());
        }
        if (elt.hasCSS()) {
            this.csscodes.add(elt.getCSS());
        }
        ++this.ncontent;
        return noproblem;
    }

    public int add(Title elt) {
        return this.addHTML4R(elt);
    }

    public int add(RScript elt) {
        return this.addHTML4R(elt);
    }

    public int add(FlexTable elt) {
        return this.addHTML4R(elt);
    }

    public int add(ParagraphSet elt) {
        return this.addHTML4R(elt);
    }

    public int add(Image elt) {
        return this.addHTML4R(elt);
    }

    public int add(RAPHAELGraphics elt) {
        return this.addHTML4R(elt);
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void addStylesheet(String file) {
        if (!this.cssfiles.contains(file)) {
            this.cssfiles.add(file);
        }
    }

    public void addJavascript(String file) {
        if (!this.jsfiles.contains(file)) {
            this.jsfiles.add(file);
        }
    }

    private String getStylesheets() {
        String out = "";
        int i = 0;
        while (i < this.cssfiles.size()) {
            out = String.valueOf(out) + "<link rel=\"stylesheet\" href=\"" + this.cssfiles.get(i) + "\" type=\"text/css\" media=\"all\" />";
            ++i;
        }
        return out;
    }

    private String getScripts() {
        String out = "";
        int i = 0;
        while (i < this.jsfiles.size()) {
            out = String.valueOf(out) + "<script type=\"text/javascript\" src=\"" + this.jsfiles.get(i) + "\"></script>";
            ++i;
        }
        return out;
    }

    public void setMenuBar(MenuBar mb) throws IOException {
        this.mb = mb;
    }

    public void setActiveMenuBarTitle(String title) throws IOException {
        this.mb.setActiveTitle(title);
    }

    public String getHead() {
        String out = "";
        out = String.valueOf(out) + "<head>";
        out = String.valueOf(out) + "<meta charset=\"" + this.charset + "\">";
        out = String.valueOf(out) + "<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">";
        out = String.valueOf(out) + "<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\" />";
        out = String.valueOf(out) + "<title>";
        out = String.valueOf(out) + StringEscapeUtils.escapeHtml((String)this.title);
        out = String.valueOf(out) + "</title>";
        out = String.valueOf(out) + this.getStylesheets();
        out = String.valueOf(out) + this.getScripts();
        out = String.valueOf(out) + "<!--[if lt IE 9]><script src=\"js/ie8-responsive-file-warning.js\"></script><![endif]-->";
        out = String.valueOf(out) + "<!-- IE10 viewport hack for Surface/desktop Windows 8 bug -->";
        out = String.valueOf(out) + "<script src=\"js/ie10-viewport-bug-workaround.js\"></script>";
        out = String.valueOf(out) + "<script src=\"js/ie-emulation-modes-warning.js\"></script>";
        out = String.valueOf(out) + "<!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->";
        out = String.valueOf(out) + "<!--[if lt IE 9]>";
        out = String.valueOf(out) + "  <script src=\"js/html5shiv.min.js\"></script>";
        out = String.valueOf(out) + "  <script src=\"js/respond.min.js\"></script>";
        out = String.valueOf(out) + "<![endif]-->";
        out = String.valueOf(out) + "</head>";
        return out;
    }

    public String getJSCode() {
        String out = "";
        out = String.valueOf(out) + "<script type=\"text/javascript\">";
        int i = 0;
        while (i < this.jscodes.size()) {
            out = String.valueOf(out) + this.jscodes.get(i);
            ++i;
        }
        out = String.valueOf(out) + "</script>";
        return out;
    }

    public String getBody(int index) {
        return this.content.get(index).getHTML();
    }

    public int writeHtml(String target) throws IOException {
        BufferedWriter output;
        File f = new File(target);
        try {
            output = new BufferedWriter(new FileWriter(f));
        }
        catch (IOException e) {
            return fileproblem;
        }
        if (this.titles.hasJS()) {
            this.jscodes.add(this.titles.getJS());
        }
        output.write("<!DOCTYPE html>");
        output.write("<html>");
        output.write(this.getHead());
        output.write("<body>");
        output.write("<a class=\"sr-only sr-only-focusable\" href=\"#content\">Skip to main content</a>");
        output.write(this.mb.getHTML());
        output.write("<div class=\"container bs-docs-container\">");
        output.write("<div class=\"row\">");
        output.write("<div class=\"col-md-9\" role=\"main\">");
        int i = 0;
        while (i < this.ncontent) {
            HTML4R elt_output = this.content.get(i);
            if (elt_output.hasHTML()) {
                output.write(elt_output.getHTML());
            }
            ++i;
        }
        output.write("</div>");
        output.write("<div class=\"col-md-3\">");
        output.write(this.titles.getHTML());
        output.write("</div>");
        output.write("</div>");
        output.write("</div>");
        output.write(this.getJSCode());
        output.write("</body>");
        output.write("</html>");
        output.close();
        return noproblem;
    }
}

