/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.html4r.elements;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.lysis.rdata.RAtomicInterface;
import org.lysis.reporters.html4r.elements.HTML4R;
import org.lysis.reporters.html4r.tools.Format;
import org.lysis.reporters.html4r.tools.utils;
import org.lysis.reporters.tables.GroupColumn;
import org.lysis.reporters.tables.TableBase;
import org.lysis.reporters.tables.TableLayoutHTML;

public class DataTable
extends TableBase
implements HTML4R {
    private TableLayoutHTML rSpecFormats;
    private String uid;

    public DataTable(TableLayoutHTML tf) throws FileNotFoundException, IOException {
        this.rSpecFormats = tf;
        this.uid = utils.generateUniqueId();
    }

    private String HeaderHTML() {
        String out = "";
        out = String.valueOf(out) + "<thead>";
        if (this.hasGroupColumns()) {
            out = String.valueOf(out) + "<tr>";
            int i = 0;
            while (i < this.groupColsSpecifications.size()) {
                String groupColName = ((GroupColumn)this.groupColsSpecifications.get(i)).getValue();
                int colSpan = ((GroupColumn)this.groupColsSpecifications.get(i)).getColspan();
                out = String.valueOf(out) + "<th class=\"GroupedheaderCell\" colSpan=\"" + colSpan + "\">";
                out = String.valueOf(out) + "<p class=\"GroupedheaderPar\">";
                out = String.valueOf(out) + "<span class=\"GroupedheaderText\">";
                out = String.valueOf(out) + groupColName;
                out = String.valueOf(out) + "</span>";
                out = String.valueOf(out) + "</p>";
                out = String.valueOf(out) + "</th>";
                ++i;
            }
            out = String.valueOf(out) + "</tr>";
        }
        out = String.valueOf(out) + "<tr>";
        for (String colName : this.columnLabels.keySet()) {
            out = String.valueOf(out) + "<th class=\"HeaderCell\">";
            out = String.valueOf(out) + "<p class=\"HeaderPar\">";
            out = String.valueOf(out) + "<span class=\"HeaderText\">";
            out = String.valueOf(out) + (String)this.columnLabels.get(colName);
            out = String.valueOf(out) + "</span>";
            out = String.valueOf(out) + "</p>";
            out = String.valueOf(out) + "</th>";
        }
        out = String.valueOf(out) + "</tr>";
        out = String.valueOf(out) + "</thead>";
        return out;
    }

    private String ContentHTML() {
        String out = "";
        out = String.valueOf(out) + "<tbody>";
        int i = 0;
        while (i < this.data.get(0).size()) {
            out = String.valueOf(out) + "<tr>";
            int j = 0;
            while (j < this.data.size()) {
                RAtomicInterface robj = this.data.get(j);
                String cell = "<td class=\"" + robj.getTdCssClass() + "\"";
                if (this.fillColors.containsKey(this.data.names(j))) {
                    cell = String.valueOf(cell) + " style=\"background-color:" + ((String[])this.fillColors.get(this.data.names(j)))[i] + ";\"";
                }
                if (this.mergeInstructions.containsKey(this.data.names(j)) && ((int[])this.mergeInstructions.get(this.data.names(j)))[i] != 0 && ((int[])this.mergeInstructions.get(this.data.names(j)))[i] != 1 && ((int[])this.mergeInstructions.get(this.data.names(j)))[i] > 1) {
                    cell = String.valueOf(cell) + " rowspan=\"" + ((int[])this.mergeInstructions.get(this.data.names(j)))[i] + "\"";
                }
                cell = String.valueOf(cell) + ">";
                if (this.mergeInstructions.containsKey(this.data.names(j)) && ((int[])this.mergeInstructions.get(this.data.names(j)))[i] == 0) {
                    cell = "";
                } else if (!this.fontColors.containsKey(this.data.names(j))) {
                    cell = String.valueOf(cell) + robj.getHTML(i, this.rSpecFormats);
                    cell = String.valueOf(cell) + "</td>";
                } else {
                    cell = String.valueOf(cell) + robj.getHTML(i, ((String[])this.fontColors.get(this.data.names(j)))[i], this.rSpecFormats);
                    cell = String.valueOf(cell) + "</td>";
                }
                out = String.valueOf(out) + cell;
                ++j;
            }
            out = String.valueOf(out) + "</tr>";
            ++i;
        }
        out = String.valueOf(out) + "</tbody>";
        return out;
    }

    @Override
    public String getHTML() {
        String out = "";
        out = String.valueOf(out) + "<table id=\"" + this.uid + "\">";
        out = String.valueOf(out) + this.HeaderHTML();
        out = String.valueOf(out) + this.ContentHTML();
        out = String.valueOf(out) + "</table>";
        return out;
    }

    @Override
    public String getCSS() {
        String out = "";
        out = String.valueOf(out) + "#" + this.uid + " .GroupedheaderCell{" + Format.getJSString(this.rSpecFormats.getGroupedheaderCell()) + "}";
        out = String.valueOf(out) + "#" + this.uid + " .HeaderCell{" + Format.getJSString(this.rSpecFormats.getHeaderCell()) + "}";
        out = String.valueOf(out) + "#" + this.uid + " .IntegerCell{" + Format.getJSString(this.rSpecFormats.getIntegerCell()) + "}";
        out = String.valueOf(out) + "#" + this.uid + " .DoubleCell{" + Format.getJSString(this.rSpecFormats.getDoubleCell()) + "}";
        out = String.valueOf(out) + "#" + this.uid + " .PercentCell{" + Format.getJSString(this.rSpecFormats.getPercentCell()) + "}";
        out = String.valueOf(out) + "#" + this.uid + " .CharacterCell{" + Format.getJSString(this.rSpecFormats.getCharacterCell()) + "}";
        out = String.valueOf(out) + "#" + this.uid + " .DateCell{" + Format.getJSString(this.rSpecFormats.getDateCell()) + "}";
        out = String.valueOf(out) + "#" + this.uid + " .LogicalCell{" + Format.getJSString(this.rSpecFormats.getLogicalCell()) + "}";
        out = String.valueOf(out) + "#" + this.uid + " .GroupedheaderPar{margin: 0px;" + Format.getJSString(this.rSpecFormats.getGroupedheaderPar()) + "}";
        out = String.valueOf(out) + "#" + this.uid + " .HeaderPar{margin: 0px;" + Format.getJSString(this.rSpecFormats.getHeaderPar()) + "}";
        out = String.valueOf(out) + "#" + this.uid + " .IntegerPar{margin: 0px;" + Format.getJSString(this.rSpecFormats.getIntegerPar()) + "}";
        out = String.valueOf(out) + "#" + this.uid + " .DoublePar{margin: 0px;" + Format.getJSString(this.rSpecFormats.getDoublePar()) + "}";
        out = String.valueOf(out) + "#" + this.uid + " .PercentPar{margin: 0px;" + Format.getJSString(this.rSpecFormats.getPercentPar()) + "}";
        out = String.valueOf(out) + "#" + this.uid + " .CharacterPar{margin: 0px;" + Format.getJSString(this.rSpecFormats.getCharacterPar()) + "}";
        out = String.valueOf(out) + "#" + this.uid + " .DatePar{margin: 0px;" + Format.getJSString(this.rSpecFormats.getDatePar()) + "}";
        out = String.valueOf(out) + "#" + this.uid + " .LogicalPar{margin: 0px;" + Format.getJSString(this.rSpecFormats.getLogicalPar()) + "}";
        out = String.valueOf(out) + "#" + this.uid + " .GroupedheaderText{" + Format.getJSString(this.rSpecFormats.getGroupedheaderText()) + "}";
        out = String.valueOf(out) + "#" + this.uid + " .HeaderText{" + Format.getJSString(this.rSpecFormats.getHeaderText()) + "}";
        out = String.valueOf(out) + "#" + this.uid + " .IntegerText{" + Format.getJSString(this.rSpecFormats.getIntegerText()) + "}";
        out = String.valueOf(out) + "#" + this.uid + " .DoubleText{" + Format.getJSString(this.rSpecFormats.getDoubleText()) + "}";
        out = String.valueOf(out) + "#" + this.uid + " .PercentText{" + Format.getJSString(this.rSpecFormats.getPercentText()) + "}";
        out = String.valueOf(out) + "#" + this.uid + " .CharacterText{" + Format.getJSString(this.rSpecFormats.getCharacterText()) + "}";
        out = String.valueOf(out) + "#" + this.uid + " .DateText{margin: 0px;" + Format.getJSString(this.rSpecFormats.getDateText()) + "}";
        out = String.valueOf(out) + "#" + this.uid + " .LogicalText{margin: 0px;" + Format.getJSString(this.rSpecFormats.getLogicalText()) + "}";
        return out;
    }

    @Override
    public String getJS() {
        return "";
    }

    @Override
    public boolean hasJS() {
        return false;
    }

    @Override
    public boolean hasHTML() {
        return true;
    }

    @Override
    public boolean hasCSS() {
        return true;
    }
}

