% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_fdc_plot.R
\name{rvn_fdc_plot}
\alias{rvn_fdc_plot}
\title{Plots summary of watershed forcing functions}
\usage{
rvn_fdc_plot(sim = NULL, obs = NULL, prd = NULL, seasonal = FALSE)
}
\arguments{
\item{sim}{simulated hydrograph xts time series}

\item{obs}{(optional) observed hydrograph xts time series}

\item{prd}{(optional) time period over which the plot is generated}

\item{seasonal}{(optional) boolean whether to add the winter and summer FDC}
}
\description{
rvn_fdc_plot generation a flow duration curve plot.
}
\details{
This function creates a flow duration curve using the rvn_hyd_extract obejct for
a given basin. The hydrograph object passed should be the output from the
rvn_hyd_extract function, which has attributes for sim and obs; if the obs is
NULL, only the sim FDC will be plotted.

If the seasonal argument is included, the winter and summer FDC lines will
be included on the plot as well.
}
\examples{

# load sample hydrograph data, two years worth of sim/obs
ff <- system.file("extdata/run1_Hydrographs.csv", package="RavenR")
run1 <- rvn_hyd_read(ff)
sim <- run1$hyd$Sub36
obs <- run1$hyd$Sub36_obs

# create FDC plot, sim only
rvn_fdc_plot(sim)

 # create seasonal FDC plot with sim and obs data
rvn_fdc_plot(sim,obs,seasonal=TRUE)

}
\seealso{
\code{\link{rvn_hyd_read}} for reading in the Hydrographs.csv file, and
\code{\link{rvn_hyd_extract}} for extracting basin flow information from a
rvn_hyd_read object
}
