% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_res_read.R
\name{rvn_res_read}
\alias{rvn_res_read}
\title{Read in Raven ReservoirStages file}
\usage{
rvn_res_read(ff = NA, tzone = "UTC")
}
\arguments{
\item{ff}{full file path to the ReservoirStages.csv file}

\item{tzone}{string indicating the timezone of the data in ff}
}
\value{
\item{res}{data frame from the file with standardized names}
}
\description{
rvn_res_read is used to read in the ReservoirStages.csv file produced by the
modelling Framework Raven.
}
\details{
This function expects a full file path to the ReservoirStages.csv file, then
reads in the file using read.csv. The main advantage of this function is
renaming the columns to nicer names and extracting the units into something
much easier to read.

This function is also built to support the rvn_res_extract function, which uses
the object created here for extracting by reference to the columns named
here, for example sub24.

ff is the full file path of the ReservoirStages.csv file. If the file is
located in the current working directory, then simply the name of the file
is sufficient.

The timezone is provided by the tzone argument as "UTC" by default, and should be adjusted by
the user to the local time zone as needed, based on the model run.
}
\examples{
# create full file path
ff <- system.file("extdata","ReservoirStages.csv", package="RavenR")

# read in the Reservoir file
myres <- rvn_res_read(ff)

# view contents
head(myres$res)
myres$units

}
\seealso{
\code{\link{rvn_res_extract}} for extraction tools related to the
rvn_res_read output file
}
