% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_gen_gridweights.R
\name{rvn_gen_gridweights}
\alias{rvn_gen_gridweights}
\title{Generate Raven grid weights from shapefile}
\usage{
rvn_gen_gridweights(
  HRUshpfile,
  Gridshpfile,
  ValidHRUIDs,
  HRUIDcol = "HRU_ID",
  gridIDcol = "cellID",
  outfile = "GridWeights.rvt"
)
}
\arguments{
\item{HRUshpfile}{polygon shapefile of HRUs with data column containing HRU IDs (.shp extension expected)}

\item{Gridshpfile}{polygon shapefile of grid cells with data column containing cell IDs (.shp extension expected)}

\item{ValidHRUIDs}{a vector of valid HRU IDs in the model}

\item{HRUIDcol}{the name of the HRUshpfile polygon which contains the HRU IDs}

\item{gridIDcol}{the name of the Gridshpfile polygon which contains the cell IDs}

\item{outfile}{optional name of output Raven gaugeweights file}
}
\value{
\item{TRUE}{returns TRUE if executed properly. Also output GaugeWeights.rvt file}
}
\description{
Generates a Raven grid weights file given an HRU shapefile and a grid shapefile.
}
\details{
Generate grid weights file GaugeWeights.rvt given an HRU shapefile with HRU ID column
HRUIDcol (default 'HRU_ID') and a grid shapefile with ID column gridIDcol (default: 'cellID')
weights are determined by the areal overlap of grid cell g and HRU k, i.e.,
 wt[k][g]=area[k][g]/area[k]
where wt[k][g] is the weight of cell g in HRU k, area[k] is the total area of HRU k,
and area[k][g] is the area of HRU k that is within cell g.

By definition, the grid domain has to completely cover the HRU domain such that the sum of
wt[k][g] for any k, over all g, is 1.0

Not a tonne of QA/QC is currently included - can fail due to bad netCDF file or inappropriate UTM zone;
uses rgdal and rgeos libraries, and the accuracy of the gIntersection() routine
leaves something to be desired. The shapefiles should be in the same projection, which is
checked for in this function.
}
\examples{

# load example rvh file
nith <- system.file("extdata",'Nith.rvh', package = "RavenR")
rvh <- rvn_rvh_read(nith)

# adjust HRU shapefile to one per subbasin for demonstration
rvh$HRUtable <- rvh$HRUtable[c(1,6,15,25),]
rvh$HRUtable$Area <- rvh$SBtable$Area
rvh$HRUtable$ID <- rvh$HRUtable$SBID

# define HRU shapefile (use subbasin shapefile for example)
HRUshpfile <- system.file("extdata","Nith_shapefile_sample.shp",package = "RavenR")

# write grid shapefile from netcdf file
nithnc <- system.file("extdata/Nith_era5_sample.nc", package="RavenR")
Gridshpfile <- file.path(tempdir(), "Nith_gridcells.shp")
myshp <- rvn_netcdf_to_gridshp(ncfile=nithnc, projID=26917, outshp=Gridshpfile)

# generate .rvt file of grid weights
ValidHRUIDs <- rvh$HRUtable$ID
tfout <- file.path(tempdir(), "Nith_GridWeights.rvt")
rvn_gen_gridweights(HRUshpfile, Gridshpfile, ValidHRUIDs,
gridIDcol = 'GridIDs', HRUIDcol = "subID", outfile = tfout)

}
\seealso{
\code{\link{rvn_netcdf_to_gridshp}} for converting netcdf files to grid shapefile format
}
\author{
James R. Craig, University of Waterloo, 2019
}
