% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attribs.R
\name{imageAttributes}
\alias{imageAttributes}
\alias{imageAttributes<-}
\title{Extended image attributes}
\usage{
imageAttributes(x)

imageAttributes(x) <- value
}
\arguments{
\item{x}{A \code{niftiImage} object.}

\item{value}{A list of new image attributes to replace any existing ones.}
}
\value{
A list of image attributes, or a modified object with these changed.
  These are essentially all attributes except those used for basic
  \code{niftiImage} objects.
}
\description{
These functions extract and replace medical image attributes that go beyond
the core metadata associated with the NIfTI file formats.
}
\details{
The DICOM (Digital Imaging and Communications in Medicine) format, and BIDS
(Brain Imaging Data Structure), which extends NIfTI, can both encapsulate
copious amounts of metadata about a scan and the patient. This metadata can
be useful for more advanced or research-focussed post-processing methods,
and standard R attributes are a natural place to store it. The
\code{imageAttributes} function returns a list of just these extended
attributes, if they exist, ignoring other attributes used by the package.
The replacement form allows this metadata to be modified or removed. These
functions currently only act on objects inheriting from the
\code{niftiImage} class.
}
\examples{
path <- system.file("extdata", "example.nii.gz", package="RNifti")
image <- readNifti(path)
imageAttributes(image)
}
\references{
More information about metadata captured by the BIDS format can
  be found at \url{https://bids.neuroimaging.io} or in the paper cited
  below.

K.J. Gorgolewski, T. Auer, V.D. Calhoun, et al. The brain imaging data
structure, a format for organizing and describing outputs of neuroimaging
experiments (2016). Scientific Data 3:160044. \doi{10.1038/sdata.2016.44}.
}
\seealso{
The \code{divest} package can convert DICOM files to NIfTI formats,
  and extract embedded metadata. More information about DICOM is available
  at \url{https://www.dicomstandard.org}.
}
\author{
Jon Clayden <code@clayden.org>
}
