/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.FileInfo;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;

public class ImagesToStack
implements PlugIn {
    private static final int rgb = 33;
    private static final int COPY_CENTER = 0;
    private static final int COPY_TOP_LEFT = 1;
    private static final int SCALE_SMALL = 2;
    private static final int SCALE_LARGE = 3;
    private static final String[] methods = new String[]{"Copy (center)", "Copy (top-left)", "Scale (smallest)", "Scale (largest)"};
    private static int method = 0;
    private static boolean bicubic;
    private static boolean keep;
    private static boolean titlesAsLabels;
    private String filter;
    private int width;
    private int height;
    private int maxWidth;
    private int maxHeight;
    private int minWidth;
    private int minHeight;
    private int minSize;
    private int maxSize;
    private Calibration cal2;
    private int stackType;
    private ImagePlus[] image;
    private String name = "Stack";

    public void run(String string) {
        this.convertImagesToStack();
    }

    public void convertImagesToStack() {
        Object object;
        int n;
        boolean bl = false;
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            IJ.error("No images are open.");
            return;
        }
        int n2 = 0;
        this.image = new ImagePlus[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            ImagePlus imagePlus = WindowManager.getImage(nArray[n]);
            if (imagePlus.getStackSize() != 1) continue;
            this.image[n2++] = imagePlus;
        }
        if (n2 < 2) {
            IJ.error("Images to Stack", "There must be at least two open images.");
            return;
        }
        this.filter = null;
        n2 = this.findMinMaxSize(n2);
        n = this.width != this.minWidth || this.height != this.minHeight ? 1 : 0;
        boolean bl2 = true;
        String string = Macro.getOptions();
        if (IJ.macroRunning() && string == null) {
            if (n != 0) {
                IJ.error("Images are not all the same size");
                return;
            }
            bl2 = false;
        }
        if (bl2) {
            GenericDialog genericDialog = new GenericDialog("Images to Stack");
            if (n != 0) {
                String string2 = "The " + n2 + " images differ in size (smallest=" + this.minWidth + "x" + this.minHeight + ",\nlargest=" + this.maxWidth + "x" + this.maxHeight + "). They will be converted\nto a stack using the specified method.";
                genericDialog.setInsets(0, 0, 5);
                genericDialog.addMessage(string2);
                genericDialog.addChoice("Method:", methods, methods[method]);
            }
            genericDialog.addStringField("Name:", this.name, 12);
            genericDialog.addStringField("Title Contains:", "", 12);
            if (n != 0) {
                genericDialog.addCheckbox("Bicubic Interpolation", bicubic);
            }
            genericDialog.addCheckbox("Use Titles as Labels", titlesAsLabels);
            genericDialog.addCheckbox("Keep Source Images", keep);
            genericDialog.showDialog();
            if (genericDialog.wasCanceled()) {
                return;
            }
            if (n != 0) {
                method = genericDialog.getNextChoiceIndex();
            }
            this.name = genericDialog.getNextString();
            this.filter = genericDialog.getNextString();
            if (n != 0) {
                bicubic = genericDialog.getNextBoolean();
            }
            titlesAsLabels = genericDialog.getNextBoolean();
            keep = genericDialog.getNextBoolean();
            if (this.filter != null && (this.filter.equals("") || this.filter.equals("*"))) {
                this.filter = null;
            }
            if (this.filter != null && (n2 = this.findMinMaxSize(n2)) == 0) {
                IJ.error("Images to Stack", "None of the images have a title containing \"" + this.filter + "\"");
            }
        } else {
            keep = false;
        }
        if (method == 2) {
            this.width = this.minWidth;
            this.height = this.minHeight;
        } else if (method == 3) {
            this.width = this.maxWidth;
            this.height = this.maxHeight;
        }
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        ImageStack imageStack = new ImageStack(this.width, this.height);
        FileInfo fileInfo = this.image[0].getOriginalFileInfo();
        if (fileInfo != null && fileInfo.directory == null) {
            fileInfo = null;
        }
        for (int i = 0; i < n2 && (object = this.image[i].getProcessor()) != null; ++i) {
            Object object2;
            String string3;
            if (((ImageProcessor)object).getMin() < d) {
                d = ((ImageProcessor)object).getMin();
            }
            if (((ImageProcessor)object).getMax() > d2) {
                d2 = ((ImageProcessor)object).getMax();
            }
            String string4 = string3 = titlesAsLabels ? this.image[i].getTitle() : null;
            if (string3 != null && (object2 = (String)this.image[i].getProperty("Info")) != null) {
                string3 = string3 + "\n" + (String)object2;
            }
            if (fileInfo != null && (object2 = this.image[i].getOriginalFileInfo()) != null && !fileInfo.directory.equals(((FileInfo)object2).directory)) {
                fileInfo = null;
            }
            switch (this.stackType) {
                case 16: {
                    object = ((ImageProcessor)object).convertToShort(false);
                    break;
                }
                case 32: {
                    object = ((ImageProcessor)object).convertToFloat();
                    break;
                }
                case 33: {
                    object = ((ImageProcessor)object).convertToRGB();
                    break;
                }
            }
            if (((ImageProcessor)object).getWidth() != this.width || ((ImageProcessor)object).getHeight() != this.height) {
                switch (method) {
                    case 0: 
                    case 1: {
                        object2 = null;
                        switch (this.stackType) {
                            case 8: {
                                object2 = new ByteProcessor(this.width, this.height);
                                break;
                            }
                            case 16: {
                                object2 = new ShortProcessor(this.width, this.height);
                                break;
                            }
                            case 32: {
                                object2 = new FloatProcessor(this.width, this.height);
                                break;
                            }
                            case 33: {
                                object2 = new ColorProcessor(this.width, this.height);
                            }
                        }
                        int n3 = 0;
                        int n4 = 0;
                        if (method == 0) {
                            n3 = (this.width - ((ImageProcessor)object).getWidth()) / 2;
                            n4 = (this.height - ((ImageProcessor)object).getHeight()) / 2;
                        }
                        ((ImageProcessor)object2).insert((ImageProcessor)object, n3, n4);
                        object = object2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        ((ImageProcessor)object).setInterpolationMethod(bicubic ? 2 : 1);
                        ((ImageProcessor)object).resetRoi();
                        object = ((ImageProcessor)object).resize(this.width, this.height);
                    }
                }
            } else if (keep) {
                object = ((ImageProcessor)object).duplicate();
            }
            imageStack.addSlice(string3, (ImageProcessor)object);
            if (keep) continue;
            this.image[i].changes = false;
            this.image[i].close();
        }
        if (imageStack.getSize() == 0) {
            return;
        }
        ImagePlus imagePlus = new ImagePlus(this.name, imageStack);
        if (this.stackType == 16 || this.stackType == 32) {
            imagePlus.getProcessor().setMinAndMax(d, d2);
        }
        if (this.cal2 != null) {
            imagePlus.setCalibration(this.cal2);
        }
        if (fileInfo != null) {
            fileInfo.fileName = "";
            fileInfo.nImages = imagePlus.getStackSize();
            imagePlus.setFileInfo(fileInfo);
        }
        imagePlus.show();
    }

    final int findMinMaxSize(int n) {
        int n2 = 0;
        this.stackType = 8;
        this.width = 0;
        this.height = 0;
        this.cal2 = this.image[0].getCalibration();
        this.maxWidth = 0;
        this.maxHeight = 0;
        this.minWidth = Integer.MAX_VALUE;
        this.minHeight = Integer.MAX_VALUE;
        this.minSize = Integer.MAX_VALUE;
        this.maxSize = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4;
            if (this.exclude(this.image[i].getTitle())) continue;
            if (this.image[i].getType() == 3) {
                this.stackType = 33;
            }
            if ((n4 = this.image[i].getBitDepth()) == 24) {
                n4 = 33;
            }
            if (n4 > this.stackType) {
                this.stackType = n4;
            }
            int n5 = this.image[i].getWidth();
            int n6 = this.image[i].getHeight();
            if (n5 > this.width) {
                this.width = n5;
            }
            if (n6 > this.height) {
                this.height = n6;
            }
            if ((n3 = n5 * n6) < this.minSize) {
                this.minSize = n3;
                this.minWidth = n5;
                this.minHeight = n6;
            }
            if (n3 > this.maxSize) {
                this.maxSize = n3;
                this.maxWidth = n5;
                this.maxHeight = n6;
            }
            Calibration calibration = this.image[i].getCalibration();
            if (!this.image[i].getCalibration().equals(this.cal2)) {
                this.cal2 = null;
            }
            this.image[n2++] = this.image[i];
        }
        return n2;
    }

    final boolean exclude(String string) {
        return this.filter != null && string != null && string.indexOf(this.filter) == -1;
    }

    static {
        titlesAsLabels = true;
    }
}

