/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;

public class Concatenator
implements PlugIn {
    ImagePlus imp1;
    ImagePlus imp2;
    static boolean keep;
    static String title;

    public void run(String string) {
        ImagePlus imagePlus;
        if (this.showDialog() && (imagePlus = this.concatenate(this.imp1, this.imp2, keep)) != null) {
            imagePlus.show();
        }
    }

    public ImagePlus concatenate(ImagePlus imagePlus, ImagePlus imagePlus2, boolean bl) {
        String string;
        ImageProcessor imageProcessor;
        int n;
        if (imagePlus.getType() != imagePlus2.getType() || imagePlus.isHyperStack() || imagePlus2.isHyperStack()) {
            this.error();
            return null;
        }
        int n2 = imagePlus.getWidth();
        int n3 = imagePlus.getHeight();
        if (n2 != imagePlus2.getWidth() || n3 != imagePlus2.getHeight()) {
            this.error();
            return null;
        }
        ImageStack imageStack = imagePlus.getStack();
        ImageStack imageStack2 = imagePlus2.getStack();
        int n4 = imageStack.getSize();
        int n5 = imageStack2.getSize();
        ImageStack imageStack3 = imagePlus.createEmptyStack();
        int n6 = 1;
        for (n = 1; n <= n4; ++n) {
            imageProcessor = imageStack.getProcessor(n6);
            string = imageStack.getSliceLabel(n6);
            if (bl || imagePlus == imagePlus2) {
                imageProcessor = imageProcessor.duplicate();
                ++n6;
            } else {
                imageStack.deleteSlice(n6);
            }
            imageStack3.addSlice(string, imageProcessor);
        }
        n6 = 1;
        for (n = 1; n <= n5; ++n) {
            imageProcessor = imageStack2.getProcessor(n6);
            string = imageStack2.getSliceLabel(n6);
            if (bl || imagePlus == imagePlus2) {
                imageProcessor = imageProcessor.duplicate();
                ++n6;
            } else {
                imageStack2.deleteSlice(n6);
            }
            imageStack3.addSlice(string, imageProcessor);
        }
        ImagePlus imagePlus3 = new ImagePlus(title, imageStack3);
        imagePlus3.setCalibration(imagePlus.getCalibration());
        if (!bl) {
            imagePlus.changes = false;
            if (imagePlus.getWindow() != null) {
                imagePlus.getWindow().close();
            }
            if (imagePlus != imagePlus2) {
                imagePlus2.changes = false;
                if (imagePlus2.getWindow() != null) {
                    imagePlus2.getWindow().close();
                }
            }
        }
        return imagePlus3;
    }

    boolean showDialog() {
        Object object;
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            IJ.noImage();
            return false;
        }
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            object = WindowManager.getImage(nArray[i]);
            stringArray[i] = object != null ? ((ImagePlus)object).getTitle() : "";
        }
        GenericDialog genericDialog = new GenericDialog("Concatenator");
        genericDialog.addChoice("Stack1:", stringArray, stringArray[0]);
        genericDialog.addChoice("Stack2:", stringArray, nArray.length > 1 ? stringArray[1] : stringArray[0]);
        genericDialog.addStringField("Title:", title, 16);
        genericDialog.addCheckbox("Keep Source Stacks", keep);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        object = new int[3];
        int n = genericDialog.getNextChoiceIndex();
        int n2 = genericDialog.getNextChoiceIndex();
        title = genericDialog.getNextString();
        keep = genericDialog.getNextBoolean();
        this.imp1 = WindowManager.getImage(nArray[n]);
        this.imp2 = WindowManager.getImage(nArray[n2]);
        return true;
    }

    void error() {
        IJ.showMessage("Concatenator", "This command requires two stacks that have\nthe same width, height and data type.");
    }

    static {
        title = "Concatenated Stacks";
    }
}

