/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.gui.Roi;
import ij.process.ImageProcessor;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class ImageRoi
extends Roi {
    private Image img;
    private Composite composite;
    private double opacity = 1.0;

    public ImageRoi(int n, int n2, BufferedImage bufferedImage) {
        super(n, n2, bufferedImage.getWidth(), bufferedImage.getHeight());
        this.img = bufferedImage;
        this.setStrokeColor(Color.black);
    }

    public ImageRoi(int n, int n2, ImageProcessor imageProcessor) {
        super(n, n2, imageProcessor.getWidth(), imageProcessor.getHeight());
        this.img = imageProcessor.createImage();
        this.setStrokeColor(Color.black);
    }

    public void draw(Graphics graphics) {
        if (this.ic == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = this.ic.getMagnification();
        int n = this.ic.screenX(this.x + this.width);
        int n2 = this.ic.screenY(this.y + this.height);
        Composite composite = null;
        if (this.composite != null) {
            composite = graphics2D.getComposite();
            graphics2D.setComposite(this.composite);
        }
        graphics.drawImage(this.img, this.ic.screenX(this.x), this.ic.screenY(this.y), n, n2, 0, 0, this.img.getWidth(null), this.img.getHeight(null), null);
        if (this.composite != null) {
            graphics2D.setComposite(composite);
        }
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public void setOpacity(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        this.opacity = d;
        this.composite = d != 1.0 ? AlphaComposite.getInstance(3, (float)d) : null;
    }

    public double getOpacity() {
        return this.opacity;
    }
}

