/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.h2.message.DbException;
import org.h2.util.IOUtils;
import org.h2.util.New;
import org.h2.util.StringUtils;
import org.h2.util.Task;
import org.h2.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceCompiler {
    private static final Class<?> JAVAC_SUN;
    HashMap<String, String> sources = New.hashMap();
    HashMap<String, Class<?>> compiled = New.hashMap();
    private String compileDir = Utils.getProperty("java.io.tmpdir", ".");

    public void setSource(String string, String string2) {
        this.sources.put(string, string2);
        this.compiled.clear();
    }

    public Class<?> getClass(String string) throws ClassNotFoundException {
        Class<?> clazz = this.compiled.get(string);
        if (clazz != null) {
            return clazz;
        }
        ClassLoader classLoader = new ClassLoader(this.getClass().getClassLoader()){

            @Override
            public Class<?> findClass(String string) throws ClassNotFoundException {
                Class<?> clazz = SourceCompiler.this.compiled.get(string);
                if (clazz == null) {
                    String string2;
                    String string3 = SourceCompiler.this.sources.get(string);
                    String string4 = null;
                    int n = string.lastIndexOf(46);
                    if (n >= 0) {
                        string4 = string.substring(0, n);
                        string2 = string.substring(n + 1);
                    } else {
                        string2 = string;
                    }
                    byte[] byArray = SourceCompiler.this.javacCompile(string4, string2, string3);
                    if (byArray == null) {
                        clazz = this.findSystemClass(string);
                    } else {
                        clazz = this.defineClass(string, byArray, 0, byArray.length);
                        SourceCompiler.this.compiled.put(string, clazz);
                    }
                }
                return clazz;
            }
        };
        return classLoader.loadClass(string);
    }

    public Method getMethod(String string) throws ClassNotFoundException {
        Method[] methodArray;
        Class<?> clazz = this.getClass(string);
        for (Method method : methodArray = clazz.getDeclaredMethods()) {
            int n = method.getModifiers();
            if (!Modifier.isPublic(n) || !Modifier.isStatic(n)) continue;
            return method;
        }
        return null;
    }

    byte[] javacCompile(String string, String string2, String string3) {
        File file = new File(this.compileDir);
        if (string != null) {
            file = new File(file, string.replace('.', '/'));
            try {
                IOUtils.mkdirs(file);
            }
            catch (IOException iOException) {
                throw DbException.convertIOException(iOException, this.compileDir);
            }
        }
        File file2 = new File(file, string2 + ".java");
        File file3 = new File(file, string2 + ".class");
        try {
            Object object;
            OutputStream outputStream = IOUtils.openFileOutputStream(file2.getAbsolutePath(), false);
            PrintWriter printWriter = new PrintWriter(IOUtils.getBufferedWriter(outputStream));
            file3.delete();
            if (string3.startsWith("package ")) {
                printWriter.println(string3);
            } else {
                int n = string3.indexOf("@CODE");
                object = "import java.util.*;\nimport java.math.*;\nimport java.sql.*;\n";
                if (n >= 0) {
                    object = string3.substring(0, n);
                    string3 = string3.substring("@CODE".length() + n);
                }
                if (string != null) {
                    printWriter.println("package " + string + ";");
                }
                printWriter.println((String)object);
                printWriter.println("public class " + string2 + " {\n" + "    public static " + string3 + "\n" + "}\n");
            }
            printWriter.close();
            if (JAVAC_SUN != null) {
                this.javacSun(file2);
            } else {
                this.javacProcess(file2);
            }
            byte[] byArray = new byte[(int)file3.length()];
            object = new DataInputStream(new FileInputStream(file3));
            ((DataInputStream)object).readFully(byArray);
            ((FilterInputStream)object).close();
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
        finally {
            file2.delete();
            file3.delete();
        }
    }

    private void javacProcess(File file) {
        this.exec("javac", "-sourcepath", this.compileDir, "-d", this.compileDir, "-encoding", "UTF-8", file.getAbsolutePath());
    }

    private int exec(String ... stringArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            SourceCompiler.copyInThread(process.getInputStream(), byteArrayOutputStream);
            SourceCompiler.copyInThread(process.getErrorStream(), byteArrayOutputStream);
            process.waitFor();
            String string = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
            this.throwSyntaxError(string);
            return process.exitValue();
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
    }

    private static void copyInThread(final InputStream inputStream, final OutputStream outputStream) {
        new Task(){

            public void call() throws IOException {
                IOUtils.copy(inputStream, outputStream);
            }
        }.execute();
    }

    private void javacSun(File file) {
        PrintStream printStream = System.err;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream2 = new PrintStream(byteArrayOutputStream);
        try {
            System.setErr(printStream2);
            Method method = JAVAC_SUN.getMethod("compile", String[].class);
            Object obj = JAVAC_SUN.newInstance();
            method.invoke(obj, new Object[]{new String[]{"-sourcepath", this.compileDir, "-d", this.compileDir, "-encoding", "UTF-8", file.getAbsolutePath()}});
            String string = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
            this.throwSyntaxError(string);
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
        finally {
            System.setErr(printStream);
        }
    }

    private void throwSyntaxError(String string) {
        if (!string.startsWith("Note:") && string.length() > 0) {
            string = StringUtils.replaceAll(string, this.compileDir, "");
            throw DbException.get(42000, string);
        }
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.sun.tools.javac.Main");
        }
        catch (Exception exception) {
            clazz = null;
        }
        JAVAC_SUN = clazz;
    }
}

