/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.store.PageStore;
import org.h2.store.PageStreamData;
import org.h2.store.PageStreamTrunk;
import org.h2.util.BitField;
import org.h2.util.IntArray;

public class PageOutputStream
extends OutputStream {
    private PageStore store;
    private final Trace trace;
    private int trunkPageId;
    private final BitField exclude;
    private int trunkNext;
    private IntArray reservedPages = new IntArray();
    private PageStreamTrunk trunk;
    private PageStreamData data;
    private int reserved;
    private int remaining;
    private byte[] buffer = new byte[1];
    private boolean needFlush;
    private boolean writing;
    private int pageCount;
    private boolean atEnd;
    private int logKey;

    public PageOutputStream(PageStore pageStore, int n, BitField bitField, int n2, boolean bl) {
        this.trace = pageStore.getTrace();
        this.store = pageStore;
        this.trunkPageId = n;
        this.exclude = bitField;
        this.logKey = n2 - 1;
        this.atEnd = bl;
    }

    void reserve(int n) throws SQLException {
        if (this.reserved < n) {
            int n2 = this.store.getPageSize();
            int n3 = PageStreamData.getCapacity(n2);
            int n4 = PageStreamTrunk.getPagesAddressed(n2);
            int n5 = 0;
            int n6 = 0;
            do {
                n5 += n4 + 1;
            } while ((n6 += n4 * n3) < n);
            int n7 = this.atEnd ? this.trunkPageId : 0;
            this.store.allocatePages(this.reservedPages, n5, this.exclude, n7);
            this.reserved += n6;
            if (this.data == null) {
                this.initNextData();
            }
        }
    }

    public void write(int n) throws IOException {
        this.buffer[0] = (byte)n;
        this.write(this.buffer);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    private void initNextData() throws SQLException {
        int n;
        int n2 = n = this.trunk == null ? -1 : this.trunk.getNextPageData();
        if (n == -1) {
            int n3 = this.trunkPageId;
            if (this.trunkNext != 0) {
                this.trunkPageId = this.trunkNext;
            }
            int n4 = PageStreamTrunk.getPagesAddressed(this.store.getPageSize());
            int[] nArray = new int[n4];
            for (int i = 0; i < n4; ++i) {
                nArray[i] = this.reservedPages.get(i);
            }
            this.trunkNext = this.reservedPages.get(n4);
            ++this.logKey;
            this.trunk = PageStreamTrunk.create(this.store, n3, this.trunkPageId, this.trunkNext, this.logKey, nArray);
            ++this.pageCount;
            this.trunk.write(null);
            this.reservedPages.removeRange(0, n4 + 1);
            n = this.trunk.getNextPageData();
        }
        this.data = PageStreamData.create(this.store, n, this.trunk.getPos(), this.logKey);
        ++this.pageCount;
        this.data.initWrite();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return;
        }
        if (this.writing) {
            Message.throwInternalError("writing while still writing");
        }
        try {
            this.reserve(n2);
            this.writing = true;
            while (n2 > 0) {
                int n3 = this.data.write(byArray, n, n2);
                if (n3 < n2) {
                    this.storePage();
                    this.initNextData();
                }
                this.reserved -= n3;
                n += n3;
                n2 -= n3;
            }
            this.needFlush = true;
            this.remaining -= n2;
        }
        catch (SQLException sQLException) {
            throw Message.convertToIOException(sQLException);
        }
        finally {
            this.writing = false;
        }
    }

    private void storePage() throws IOException {
        try {
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("pageOut.storePage " + this.data);
            }
            this.data.write(null);
        }
        catch (SQLException sQLException) {
            throw Message.convertToIOException(sQLException);
        }
    }

    public void flush() throws IOException {
        if (this.needFlush) {
            this.storePage();
            this.needFlush = false;
        }
    }

    public void close() {
        this.store = null;
    }

    int getCurrentDataPageId() {
        return this.data.getPos();
    }

    void fillPage() throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("pageOut.storePage fill " + this.data.getPos());
        }
        this.reserve(this.data.getRemaining() + 1);
        this.reserved -= this.data.getRemaining();
        this.data.write(null);
        this.initNextData();
    }

    long getSize() {
        return this.pageCount * this.store.getPageSize();
    }

    void free(PageStreamTrunk pageStreamTrunk) throws SQLException {
        this.pageCount -= pageStreamTrunk.free();
    }

    int getCurrentLogKey() {
        return this.trunk.getLogKey();
    }

    void freeReserved() throws SQLException {
        if (this.reservedPages.size() > 0) {
            int[] nArray = new int[this.reservedPages.size()];
            this.reservedPages.toArray(nArray);
            this.reservedPages = new IntArray();
            this.reserved = 0;
            for (int n : nArray) {
                this.store.free(n);
            }
        }
    }
}

