/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.h2.constant.SysProperties;
import org.h2.store.fs.FileObject;
import org.h2.util.FileUtils;

public class FileObjectDiskMapped
implements FileObject {
    private static final long GC_TIMEOUT_MS = 10000L;
    private final String name;
    private final FileChannel.MapMode mode;
    private RandomAccessFile file;
    private MappedByteBuffer mapped;

    FileObjectDiskMapped(String string, String string2) throws IOException {
        this.mode = "r".equals(string2) ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
        this.name = string;
        this.file = new RandomAccessFile(string, string2);
        this.reMap();
    }

    private void unMap() {
        if (this.mapped != null) {
            Object object;
            boolean bl;
            this.mapped.force();
            if (SysProperties.NIO_CLEANER_HACK) {
                try {
                    bl = false;
                    object = this.mapped.getClass().getMethod("cleaner", new Class[0]);
                    ((Method)object).setAccessible(true);
                    Object object2 = ((Method)object).invoke((Object)this.mapped, new Object[0]);
                    Method method = object2.getClass().getMethod("clear", new Class[0]);
                    method.invoke(object2, new Object[0]);
                }
                catch (Throwable throwable) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bl) {
                object = new WeakReference<MappedByteBuffer>(this.mapped);
                this.mapped = null;
                long l = System.currentTimeMillis();
                while (((Reference)object).get() != null) {
                    if (System.currentTimeMillis() - l > 10000L) {
                        throw new RuntimeException("Timeout (10000 ms) reached while trying to GC mapped buffer");
                    }
                    System.gc();
                    Thread.yield();
                }
            }
        }
    }

    private void reMap() throws IOException {
        if (this.file.length() > Integer.MAX_VALUE) {
            throw new RuntimeException("File over 2GB is not supported yet");
        }
        int n = 0;
        if (this.mapped != null) {
            n = this.mapped.position();
            this.mapped.force();
            this.unMap();
        }
        this.mapped = this.file.getChannel().map(this.mode, 0L, this.file.length());
        if (SysProperties.NIO_LOAD_MAPPED) {
            this.mapped.load();
        }
        this.mapped.position(n);
    }

    public void close() throws IOException {
        this.unMap();
        this.file.close();
        this.file = null;
    }

    public long getFilePointer() {
        return this.mapped.position();
    }

    public String getName() {
        return this.name;
    }

    public long length() throws IOException {
        return this.file.length();
    }

    public void readFully(byte[] byArray, int n, int n2) {
        this.mapped.get(byArray, n, n2);
    }

    public void seek(long l) {
        this.mapped.position((int)l);
    }

    public void setFileLength(long l) throws IOException {
        FileUtils.setLength(this.file, l);
        this.reMap();
    }

    public void sync() throws IOException {
        this.file.getFD().sync();
        this.mapped.force();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.mapped.capacity() < this.mapped.position() + n2) {
            this.setFileLength(this.mapped.position() + n2);
        }
        this.mapped.put(byArray, n, n2);
    }
}

