\alias{gFileDelete}
\name{gFileDelete}
\title{gFileDelete}
\description{Deletes a file. If the \code{file} is a directory, it will only be deleted if it 
is empty.}
\usage{gFileDelete(object, cancellable = NULL, .errwarn = TRUE)}
\arguments{
\item{\verb{object}}{input \code{\link{GFile}}.}
\item{\verb{cancellable}}{optional \code{\link{GCancellable}} object, \code{NULL} to ignore.}
\item{.errwarn}{Whether to issue a warning on error or fail silently}
}
\details{If \code{cancellable} is not \code{NULL}, then the operation can be cancelled by
triggering the cancellable object from another thread. If the operation
was cancelled, the error \code{G_IO_ERROR_CANCELLED} will be returned.}
\value{
A list containing the following elements:
\item{retval}{[logical] \code{TRUE} if the file was deleted. \code{FALSE} otherwise.}
\item{\verb{error}}{a \code{\link{GError}}, or \code{NULL} }
}
\author{Derived by RGtkGen from GTK+ documentation}
\keyword{internal}
