\alias{GtkStatusbar}
\alias{gtkStatusbar}
\name{GtkStatusbar}
\title{GtkStatusbar}
\description{Report messages of minor importance to the user}
\section{Methods and Functions}{
\code{\link{gtkStatusbarNew}(show = TRUE)}\cr
\code{\link{gtkStatusbarGetContextId}(object, context.description)}\cr
\code{\link{gtkStatusbarPush}(object, context.id, text)}\cr
\code{\link{gtkStatusbarPop}(object, context.id)}\cr
\code{\link{gtkStatusbarRemove}(object, context.id, message.id)}\cr
\code{\link{gtkStatusbarSetHasResizeGrip}(object, setting)}\cr
\code{\link{gtkStatusbarGetHasResizeGrip}(object)}\cr
\code{gtkStatusbar(show = TRUE)}
}
\section{Hierarchy}{\preformatted{GObject
   +----GInitiallyUnowned
         +----GtkObject
               +----GtkWidget
                     +----GtkContainer
                           +----GtkBox
                                 +----GtkHBox
                                       +----GtkStatusbar}}
\section{Interfaces}{GtkStatusbar implements
 AtkImplementorIface and  \verb{\link{GtkBuildable}}.}
\section{Detailed Description}{A \verb{\link{GtkStatusbar}} is usually placed along the bottom of an application's main
\verb{\link{GtkWindow}}. It may provide a regular commentary of the application's status
(as is usually the case in a web browser, for example), or may be used to
simply output a message when the status changes, (when an upload is complete
in an FTP client, for example). 
It may also have a resize grip (a triangular area in the lower right corner) 
which can be clicked on to resize the window containing the statusbar.
  
Status bars in GTK+ maintain a stack of messages. The message at
the top of the each bar's stack is the one that will currently be displayed.
  
Any messages added to a statusbar's stack must specify a \emph{context 
id} that is used to uniquely identify the source of a message. 
This context id can be generated by \code{\link{gtkStatusbarGetContextId}}, given a 
message and the statusbar that it will be added to. Note that messages are 
stored in a stack, and when choosing which message to display, the stack 
structure is adhered to, regardless of the context identifier of a message.
  
One could say that a statusbar maintains one stack of messages for display
purposes, but allows multiple message producers to maintain sub-stacks of
the messages they produced (via context ids).
  
Status bars are created using \code{\link{gtkStatusbarNew}}.
  
Messages are added to the bar's stack with \code{\link{gtkStatusbarPush}}.
  
The message at the top of the stack can be removed using \code{\link{gtkStatusbarPop}}. 
A message can be removed from anywhere in the stack if its message_id was 
recorded at the time it was added. This is done using \code{\link{gtkStatusbarRemove}}.}
\section{Structures}{\describe{\item{\verb{GtkStatusbar}}{
Contains private data that should be modified with the functions described 
below.

}}}
\section{Convenient Construction}{\code{gtkStatusbar} is the equivalent of \code{\link{gtkStatusbarNew}}.}
\section{Signals}{\describe{
\item{\code{text-popped(statusbar, context.id, text, user.data)}}{
Is emitted whenever a new message is popped off a statusbar's stack.  

\describe{
\item{\code{statusbar}}{[\verb{\link{GtkStatusbar}}]  the object which received the signal.}
\item{\code{context.id}}{[numeric]  the context id of the relevant message/statusbar.}
\item{\code{text}}{[character]  the message that was just popped.}
\item{\code{user.data}}{[R object] user data set when the signal handler was connected.}
}


}
\item{\code{text-pushed(statusbar, context.id, text, user.data)}}{
Is emitted whenever a new message gets pushed onto a statusbar's stack.  

\describe{
\item{\code{statusbar}}{[\verb{\link{GtkStatusbar}}]  the object which received the signal.}
\item{\code{context.id}}{[numeric]  the context id of the relevant message/statusbar.}
\item{\code{text}}{[character]  the message that was pushed.}
\item{\code{user.data}}{[R object] user data set when the signal handler was connected.}
}


}
}}
\section{Properties}{\describe{\item{\verb{has-resize-grip} [logical : Read / Write]}{

Whether the statusbar has a grip for resizing the toplevel window.  

  Default value: TRUE  Since  2.4

}}}
\section{Style Properties}{\describe{\item{\verb{shadow-type} [\code{\link{GtkShadowType}} : Read]}{

Style of bevel around the statusbar text.  Default value: GTK_SHADOW_IN

}}}
\references{\url{http://developer.gnome.org/doc/API/2.0/gtk/GtkStatusbar.html}}
\author{Derived by RGtkGen from GTK+ documentation}
\keyword{internal}
