% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oc2S.R
\name{oc2S}
\alias{oc2S}
\alias{oc2S.betaMix}
\alias{oc2S.normMix}
\alias{oc2S.gammaMix}
\title{Operating Characteristics for 2 Sample Design}
\usage{
oc2S(prior1, prior2, n1, n2, decision, ...)

\method{oc2S}{betaMix}(prior1, prior2, n1, n2, decision, eps, ...)

\method{oc2S}{normMix}(
  prior1,
  prior2,
  n1,
  n2,
  decision,
  sigma1,
  sigma2,
  eps = 1e-06,
  Ngrid = 10,
  ...
)

\method{oc2S}{gammaMix}(prior1, prior2, n1, n2, decision, eps = 1e-06, ...)
}
\arguments{
\item{prior1}{Prior for sample 1.}

\item{prior2}{Prior for sample 2.}

\item{n1, n2}{Sample size of the respective samples. Sample size \code{n1} must be greater than 0 while sample size \code{n2} must be greater or equal to 0.}

\item{decision}{Two-sample decision function to use; see \code{\link{decision2S}}.}

\item{...}{Optional arguments.}

\item{eps}{Support of random variables are determined as the
interval covering \code{1-eps} probability mass. Defaults to
\eqn{10^{-6}}.}

\item{sigma1}{The fixed reference scale of sample 1. If left
unspecified, the default reference scale of the prior 1 is assumed.}

\item{sigma2}{The fixed reference scale of sample 2. If left
unspecified, the default reference scale of the prior 2 is assumed.}

\item{Ngrid}{Determines density of discretization grid on which
decision function is evaluated (see below for more details).}
}
\value{
Returns a function which when called with two arguments
\code{theta1} and \code{theta2} will return the frequencies at
which the decision function is evaluated to 1 whenever the data is
distributed according to the known parameter values in each
sample. Note that the returned function takes vector arguments.
}
\description{
The \code{oc2S} function defines a 2 sample design (priors, sample
sizes & decision function) for the calculation of operating
characeristics. A function is returned which calculates the
calculates the frequency at which the decision function is
evaluated to 1 when assuming known parameters.
}
\details{
The \code{oc2S} function defines a 2 sample design and
returns a function which calculates its operating
characteristics. This is the frequency with which the decision
function is evaluated to 1 under the assumption of a given true
distribution of the data defined by the known parameter
\eqn{\theta_1} and \eqn{\theta_2}. The 2 sample design is defined
by the priors, the sample sizes and the decision function,
\eqn{D(y_1,y_2)}. These uniquely define the decision boundary , see
\code{\link{decision2S_boundary}}.

Calling the \code{oc2S} function calculates the decision boundary
\eqn{D_1(y_2)} (see \code{\link{decision2S_boundary}}) and returns
a function which can be used to calculate the desired frequency
which is evaluated as

\deqn{ \int f_2(y_2|\theta_2) F_1(D_1(y_2)|\theta_1) dy_2. }

See below for examples and specifics for the supported mixture
priors.
}
\section{Methods (by class)}{
\itemize{
\item \code{oc2S(betaMix)}: Applies for binomial model with a mixture
beta prior. The calculations use exact expressions.  If the
optional argument \code{eps} is defined, then an approximate method
is used which limits the search for the decision boundary to the
region of \code{1-eps} probability mass. This is useful for designs
with large sample sizes where an exact approach is very costly to
calculate.

\item \code{oc2S(normMix)}: Applies for the normal model with known
standard deviation \eqn{\sigma} and normal mixture priors for the
means. As a consequence from the assumption of a known standard
deviation, the calculation discards sampling uncertainty of the
second moment. The function has two extra arguments (with
defaults): \code{eps} (\eqn{10^{-6}}) and \code{Ngrid} (10). The
decision boundary is searched in the region of probability mass
\code{1-eps}, respectively for \eqn{y_1} and \eqn{y_2}. The
continuous decision function is evaluated at a discrete grid, which
is determined by a spacing with \eqn{\delta_2 =
\sigma_2/\sqrt{N_{grid}}}. Once the decision boundary is evaluated
at the discrete steps, a spline is used to inter-polate the
decision boundary at intermediate points.

\item \code{oc2S(gammaMix)}: Applies for the Poisson model with a gamma
mixture prior for the rate parameter.  The function
\code{oc2S} takes an extra argument \code{eps} (defaults to \eqn{10^{-6}}) which
determines the region of probability mass \code{1-eps} where the
boundary is searched for \eqn{y_1} and \eqn{y_2}, respectively.

}}
\examples{

# example from Schmidli et al., 2014
dec <- decision2S(0.975, 0, lower.tail=FALSE)

prior_inf <- mixbeta(c(1, 4, 16))
prior_rob <- robustify(prior_inf, weight=0.2, mean=0.5)
prior_uni <- mixbeta(c(1, 1,  1))

N <- 40
N_ctl <- N - 20

# compare designs with different priors
design_uni <- oc2S(prior_uni, prior_uni, N, N_ctl, dec)
design_inf <- oc2S(prior_uni, prior_inf, N, N_ctl, dec)
design_rob <- oc2S(prior_uni, prior_rob, N, N_ctl, dec)

# type I error
curve(design_inf(x,x), 0, 1)
curve(design_uni(x,x), lty=2, add=TRUE)
curve(design_rob(x,x), lty=3, add=TRUE)

# power
curve(design_inf(0.2+x,0.2), 0, 0.5)
curve(design_uni(0.2+x,0.2), lty=2, add=TRUE)
curve(design_rob(0.2+x,0.2), lty=3, add=TRUE)


}
\references{
Schmidli H, Gsteiger S, Roychoudhury S, O'Hagan A, Spiegelhalter D, Neuenschwander B.
Robust meta-analytic-predictive priors in clinical trials with historical control information.
\emph{Biometrics} 2014;70(4):1023-1032.
}
\seealso{
Other design2S: 
\code{\link{decision2S}()},
\code{\link{decision2S_boundary}()},
\code{\link{pos2S}()}
}
\concept{design2S}
