% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional_data.R
\name{create_functional_data}
\alias{create_functional_data}
\title{Makes a functional data with splines from a Pupil_difference_data dataframe.}
\usage{
create_functional_data(data, pupil, basis, order)
}
\arguments{
\item{data}{a Pupil_difference_data dataframe}

\item{pupil}{Column name indicating pupil data to fit}

\item{basis}{Integer specifying number of basis functions to create a b-spline basis}

\item{order}{Integer specifying order of b-splines (one higher than the degree)}
}
\value{
A Pupil_difference_data dataframe fitted with b-splines.
}
\description{
This function turns difference data into fitted splines in order to carry out functional data analysis.
Under the hood this passes basis and order to fda::Data2fd, and fda::create.bspline.basis, and is
mandatory before running run_functional_t_test. It is recommended to read the documentation for
package fda for further information.
}
\examples{
Sdata <- make_pupillometryr_data(data = pupil_data,
                               subject = ID,
                               trial = Trial,
                               time = Time,
                               condition = Type)
regressed_data <- regress_data(data = Sdata, pupil1 = RPupil, pupil2 = LPupil)
mean_data <- calculate_mean_pupil_size(data = regressed_data, pupil1 = RPupil, pupil2 = LPupil)
base_data <- baseline_data(data = mean_data, pupil = mean_pupil, start = 0, stop = 100)
differences <- create_difference_data(data = base_data, pupil = mean_pupil)
spline_data <- create_functional_data(data = differences, pupil = mean_pupil, basis = 10, order = 4)

}
\seealso{
fda package
}
