% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkDependencies.R
\name{checkDependencies}
\alias{checkDependencies}
\title{checkDependencies}
\usage{
checkDependencies(repo, dependencyType = c("Imports", "Depends"), nThreads = 1)
}
\arguments{
\item{repo}{(\code{Repository})\cr
Repository object.}

\item{dependencyType}{(\code{character()})\cr
Types of dependencies to be included}

\item{nThreads}{(\code{numeric(1)}: 1)
Number of threads to use to fetch permitted packages}
}
\value{
(\code{data.frame()})\cr
Data frame with all the packages that are now permitted.\tabular{ll}{
   column \tab data type \cr
   package \tab \code{character()} \cr
   version \tab \code{character()} \cr
}
}
\description{
Check package dependencies
}
\examples{
\donttest{
# Set cahce, usually not required.
withr::local_envvar(
  R_USER_CACHE_DIR = tempfile()
)

fetchedRepo <- tryCatch(
  {
    # Set dir to clone repository to.
    tempDir <- tempdir()
    pathToRepo <- file.path(tempDir, "glue")

    # Clone repo
    git2r::clone(
      url = "https://github.com/tidyverse/glue.git",
      local_path = pathToRepo
    )

    # Create instance of Repository object.
    repo <- PaRe::Repository$new(path = pathToRepo)

    # Set fetchedRepo to TRUE if all goes well.
    TRUE
  },
  error = function(e) {
    # Set fetchedRepo to FALSE if an error is encountered.
    FALSE
  },
  warning = function(w) {
    # Set fetchedRepo to FALSE if a warning is encountered.
    FALSE
  }
)

if (fetchedRepo) {
  # Use checkDependencies on the Repository object.
  checkDependencies(repo)
  checkDependencies(repo, dependencyType = c("Imports", "Suggests"))
}
}
}
