% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLR_determination.R
\name{plr_weighted_regression}
\alias{plr_weighted_regression}
\title{Weighted Regression}
\usage{
plr_weighted_regression(
  data,
  power_var,
  time_var,
  model,
  per_year = 12,
  weight_var = NA
)
}
\arguments{
\item{data}{The result of a power predictive model}

\item{power_var}{String name of the variable used as power}

\item{time_var}{String name of the variable used as time}

\item{model}{String name of the model that the data was passed through}

\item{per_year}{the time step count per year based on the model - 
12 for month-by-month, 52 for week-by-week, and 365 for day-by-day}

\item{weight_var}{Used to weight regression, typically sigma.}
}
\value{
Returns PLR value and error evaluated with linear regression
}
\description{
Automatically calculates Performance Loss Rate (PLR)
using weighted linear regression. Note that it needs data from 
a power predictive model.
}
\examples{
# build var_list
var_list <- plr_build_var_list(time_var = "timestamp",
                               power_var = "power",
                               irrad_var = "g_poa",
                               temp_var = "mod_temp",
                               wind_var = NA)
# Clean Data
test_dfc <- plr_cleaning(test_df, var_list, irrad_thresh = 100,
                         low_power_thresh = 0.01, high_power_cutoff = NA)
                         
# Perform the power predictive modeling step
test_xbx_wbw_res <- plr_xbx_model(test_dfc, var_list, by = "week",
                                  data_cutoff = 30, predict_data = NULL)
                                  
# Calculate Performance Loss Rate
xbx_wbw_plr <- plr_weighted_regression(test_xbx_wbw_res, 
                                       power_var = 'power_var', 
                                       time_var = 'time_var',
                                       model = "xbx", 
                                       per_year = 52, 
                                       weight_var = 'sigma')

}
