% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_cleaning.R
\name{plr_variable_check}
\alias{plr_variable_check}
\title{Define Standard Variable Names}
\usage{
plr_variable_check(df)
}
\arguments{
\item{df}{A dataframe containing pv data.}
}
\value{
Returns a dataframe containing standard variable names (no data). It will not include
  windspeed if the variable was not already included. This is frequently an input
  of other functions.
}
\description{
The method determines the variable names used by the input dataframe.
 It looks for the following labels:
 \itemize{
   \item power_var <- iacp; if not, sets to idcp
   \item time_var <- tmst; if not ,sets to tutc
   \item irrad_var <- poay; if not, sets to ghir
   \item temp_var <- temp; if not, sets to modt
   \item wind_var <- wspa; if applicable, else NULL
}
 This function assumes data is in a standard HBase format. If you are using other data
 (as you most likely are) you should use the companion function, \code{\link{plr_build_var_list}}.
}
\examples{
var_list <- plr_variable_check(test_df)
 
}
