% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likPOUMM.R
\name{dVNodesGivenTreePOUMM}
\alias{dVNodesGivenTreePOUMM}
\title{Multivariate density of observed values along a tree given an OU process of 
evolution and root-value}
\usage{
dVNodesGivenTreePOUMM(z, tree, alpha, theta, sigma, sigmae = 0, e = rep(0,
  length(z)), log = TRUE)
}
\arguments{
\item{z}{A numeric vector of size length(tree$tip.label)+tree$Nnode 
representing the observed values at the tips, root and internal nodes.}

\item{tree}{An object of class phylo.}

\item{alpha, theta, sigma}{Numeric values, parameters of the OU model.}

\item{sigmae}{Numeric non-negative value or vector of length(z) elements 
(default 0). Specifies the
 standard deviation of random environmental contribution (and eventually 
 measurement error) to be added to the values. Note that if measurement standard
 error, se, is known and needs to be added to the environmental contribution,
 the right way to specify the parameter would be sqrt(sigmae^2+se^2), not
 sigmae+se.}

\item{e}{Numeric vector of size length(z) representing exactly known 
error (sum of environmental contribution and measurement error). 
Defaults to a vector of zeroes.}

\item{log}{Logical indicating whether a log-likelihood should be returned 
instead of a likelihood. Default is TRUE.}
}
\value{
A numeric value, the multivariate probability density of z under the 
  given parameters.
}
\description{
Calculates the conditional probability density of observed 
  values at the tips and internal nodes of a tree, given that tree, the value
  at the root, z[N+1], where N is the number of tips in the tree, known 
  measurement error e for each value in z, and a POUMM model of evolution. 
  This function is mostly used to calculate the likelihood of simulated data
  under known model parameters.
}

