% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KowaAP7000Client.r
\name{kowa.presentStatic}
\alias{kowa.presentStatic}
\title{Present static on Kowa AP7000 (internal use)}
\arguments{
\item{stim}{Stimulus to present (a list, see details).}

\item{nextStim}{The stimulus to present after stim
(it is not presented, but projector can move to it during response window)}
}
\value{
A list containing
\itemize{
\item \code{err}  String message or NULL for no error.
\item \code{seen} 1 if seen, 0 otherwise.
\item \code{time} Reaction time (if seen).
\item \code{pupilX}
\item \code{pupilY}
\item \code{purkinjeX}
\item \code{purkinjeY}
}
}
\description{
Implementation of opiPresent for the Kowa AP7000 machine.
Version for opiStaticStimulus.

This is for internal use only. Use \code{\link[=opiPresent]{opiPresent()}} with
\code{stim} as class \code{opiStaticStimulus} and you will get the Value back.
}
\details{
\code{stim} is a list containing at least the following 3 elements:
\itemize{
\item \code{x}, x-coordinate in degrees (floating point) (range $[-80,80]$).
\item \code{y}, y-coordinate in degrees (floating point) (range $[-70,65]$).
\item \code{level} is luminance in cd/\eqn{\mbox{m}^2}{m^2}, and is rounded to the nearest
whole dB for display (range 0 to 50). 0dB is 10000aps.
\item \code{duration} of stimulus on in milliseconds (range $[100, 1200]$).
\item \code{responseWindow} from start of stimulus presentation in milliseconds (max 5000).
\item \code{size} one of \code{.opi_env$KowaAP7000$SIZES_DEGREES}.
\item \code{color} one of \code{.opi_env$KowaAP7000$COLOR_WHITE}, \code{.opi_env$KowaAP7000$COLOR_GREEN}, \code{.opi_env$KowaAP7000$COLOR_BLUE}, or \code{.opi_env$KowaAP7000$COLOR_RED}
}
}
