\name{checkconstraints_HHhead_at_group_level}
\alias{checkconstraints_HHhead_at_group_level}
\title{
Checking a data matrix of households for the possible/impossible status under a predefined set of structural zeros.
}
\description{
Checking a data matrix of households for the possible/impossible status under a predefined set of structural zeros.
}
\usage{
checkconstraints_HHhead_at_group_level(data, neededpossiblehh, hh_size, parallel)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data }{
  A household data matrix generated by calling \verb{samplinghouseholds}.
  }
  \item{neededpossiblehh }{
  The number of possible households needed before checking is stopped.
  }
  \item{hh_size }{
  The household size for the households in \verb{data}.
  }
  \item{parallel}{
  Logical indicator for running the function in parallel mode.
}
}
\details{
Given an input household data matrix, these functions will check the possible/impossible status of each household and also output the desired number of possible and impossible households separately. \verb{checkconstraints_HHhead_at_group_level} checks contraints when the household head is moved to the household level. For the list of structural zeros currently included, see the documentation for \verb{checkconstraints}.
}
\value{
A list containing information on checking result.
  \item{outcome }{An indicator vector for the possible/impossible household status under constraints.}
  \item{Households }{A data matrix for impossible households.}
  \item{Index }{A vector for the original indexes of households when possible households are found. Generally not to be used.}
  \item{synHouseholds }{A data matrix for possible households.}
  \item{possible }{The actual number of possible households returned.}
}

\author{
Quanli Wang, Olanrewaju Akande
}

\keyword{constraints}
\keyword{impossible household}
\keyword{possible household}

