% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NAP_oc.R
\name{NAP_oc}
\alias{NAP_oc}
\title{Simulation for operating-characteristics applying NAP-based priors}
\usage{
NAP_oc(
  NAP_prior = NULL,
  theta_EC2 = 0,
  n_EC2 = 200,
  lambda = 2,
  sim_model = c("Exponential", "Weibull"),
  model_param = 0.05,
  iter = 2000,
  chains = 4,
  seed = 123,
  nsim = 100,
  jags_model = NULL
)
}
\arguments{
\item{NAP_prior}{An object returned by \code{\link{NAP_prior}()} that contains
the prior specification and (for eNAP) any calibrated tuning parameters \code{a}, \code{b}.}

\item{theta_EC2}{Numeric scalar. True log-hazard ratio for \code{E} vs \code{C2}
used to generate the direct trial data.}

\item{n_EC2}{Integer. Total sample size for the simulated \code{E} vs \code{C2} trial.}

\item{lambda}{Numeric scalar \eqn{> 0}. Randomization ratio \code{E:C2}; e.g.,
\code{lambda = 2} means 2:1 allocation to \code{E}:\code{C2}.}

\item{sim_model}{Character string. Event-time model used to simulate individual
times; one of \code{"Exponential"} or \code{"Weibull"}.}

\item{model_param}{Named numeric vector for the baseline hazard of the control arm.
For \code{sim_model = "Exponential"}, use \code{c(rate = ...)}.
For \code{sim_model = "Weibull"}, use \code{c(shape = ..., rate = ...)}.}

\item{iter}{Integer. Total MCMC iterations per chain for JAGS (default \code{2000}).}

\item{chains}{Integer. Number of MCMC chains (default \code{4}).}

\item{seed}{Integer. Random seed for the simulation replicates.}

\item{nsim}{Integer. Number of Monte Carlo replicates (default \code{100}).}

\item{jags_model}{Either a length-1 character string containing JAGS model code
(e.g., a packaged object such as \code{jags_model_RE}) or a file path to a
\code{.txt} JAGS model. If \code{NULL}, a default FE/RE model is chosen to
match the \code{NAP_prior} mode.}
}
\value{
A data frame with one row per replicate containing:
\itemize{
\item \code{post_mean}, \code{post_sd}, \code{low95}, \code{hi95}
— posterior mean, SD, and 95\\% interval for \code{theta_{E,C2}}.
\item \code{prob_E_better} — posterior probability \code{theta_{E,C2} < 0}.
\item \code{prior_weight}, \code{post_weight} — prior and updated weights
used in the mixture (for eNAP, \code{prior_weight} is \code{w(Z)}).
\item \code{sigma_hat} — posterior mean of between-study SD (RE only; \code{NA} for FE).
}
}
\description{
Runs Monte Carlo simulations of an \code{E} vs \code{C2} trial and performs
Bayesian analysis with a NAP-based prior constructed by \code{\link{NAP_prior}()}.
The routine supports both single external study setting and multiple external studies
settings as encoded in the provided \code{NAP_prior} object, and works with either a fixed mixture
weight (mNAP) or an elastic, data-adaptive weight (eNAP).
}
