% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mult-MSHAPESs.R
\name{MSHAPES}
\alias{MSHAPES}
\title{Mean shape calculation for Coo, Coe, etc.}
\usage{
MSHAPES(x, fac = NULL, FUN = mean, nb.pts = 120, ...)
}
\arguments{
\item{x}{a list, array, Ldk, LdkCoe, OutCoe or OpnCoe or PCA object}

\item{fac}{factor specification for \link{fac_dispatcher}}

\item{FUN}{a function to compute the mean shape (\link{mean} by default, by \link{median} can be considered)}

\item{nb.pts}{numeric the number of points for calculated shapes (only Coe objects)}

\item{...}{useless here.}
}
\value{
the averaged shape; on Coe objects, a list with two components: \code{$Coe} object of the same class, and
\code{$shp} a list of matrices of (x, y) coordinates. On \link{PCA} and \link{LDA} objects, the FUN (typically mean or median)
of scores on \code{PCs} or \code{LDs}. This method used on the latter objects may be moved to another function at some point.
}
\description{
Quite a versatile function that calculates mean (or median, or whatever function)
on list or an array of shapes, an Ldk object. It can also be used on Coe objects.
In that case, the reverse transformation (from coefficients to shapes) is calculated, (within
groups defined with the fac argument if provided) and the Coe object is \emph{also} returned
(in \verb{$Coe}) along with a list of shapes (in \verb{$shp}) and can then be passed to \code{plot_MSHAPES}.
}
\examples{
#### on shapes
MSHAPES(wings)
MSHAPES(wings$coo)
MSHAPES(coo_sample(bot, 24)$coo)
stack(wings)
coo_draw(MSHAPES(wings))

bot.f <- efourier(bot, 12)
MSHAPES(bot.f) # the mean (global) shape
ms <- MSHAPES(bot.f, 'type')
ms$Coe
class(ms$Coe)
ms <- ms$shp
coo_plot(ms$beer)
coo_draw(ms$whisky, border='forestgreen')
}
\seealso{
Other multivariate: 
\code{\link{CLUST}()},
\code{\link{KMEANS}()},
\code{\link{KMEDOIDS}()},
\code{\link{LDA}()},
\code{\link{MANOVA_PW}()},
\code{\link{MANOVA}()},
\code{\link{MDS}()},
\code{\link{NMDS}()},
\code{\link{PCA}()},
\code{\link{classification_metrics}()}
}
\concept{multivariate}
